/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.felhr.usbserial.SerialInputStream;
import com.felhr.usbserial.SerialOutputStream;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;

public class CDCSerialDevice
extends UsbSerialDevice {
    private static final String CLASS_ID = CDCSerialDevice.class.getSimpleName();
    private static final int CDC_REQTYPE_HOST2DEVICE = 33;
    private static final int CDC_REQTYPE_DEVICE2HOST = 161;
    private static final int CDC_SET_LINE_CODING = 32;
    private static final int CDC_GET_LINE_CODING = 33;
    private static final int CDC_SET_CONTROL_LINE_STATE = 34;
    private static final int CDC_SET_CONTROL_LINE_STATE_RTS = 2;
    private static final int CDC_SET_CONTROL_LINE_STATE_DTR = 1;
    private static final byte[] CDC_DEFAULT_LINE_CODING = new byte[]{0, -62, 1, 0, 0, 0, 8};
    private static final int CDC_CONTROL_LINE_ON = 3;
    private static final int CDC_CONTROL_LINE_OFF = 0;
    private UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private UsbRequest requestIN;
    private int initialBaudRate = 0;
    private int controlLineState = 3;

    public CDCSerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        this(device, connection, -1);
    }

    public CDCSerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        super(device, connection);
        this.mInterface = device.getInterface(iface >= 0 ? iface : CDCSerialDevice.findFirstCDC(device));
    }

    @Override
    public void setInitialBaudRate(int initialBaudRate) {
        this.initialBaudRate = initialBaudRate;
    }

    @Override
    public int getInitialBaudRate() {
        return this.initialBaudRate;
    }

    @Override
    public boolean open() {
        boolean ret = this.openCDC();
        if (ret) {
            this.requestIN = new UsbRequest();
            this.requestIN.initialize(this.connection, this.inEndpoint);
            this.restartWorkingThread();
            this.restartWriteThread();
            this.setThreadsParams(this.requestIN, this.outEndpoint);
            this.asyncMode = true;
            this.isOpen = true;
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void close() {
        this.setControlCommand(34, 0, null);
        this.killWorkingThread();
        this.killWriteThread();
        this.connection.releaseInterface(this.mInterface);
        this.connection.close();
        this.isOpen = false;
    }

    @Override
    public boolean syncOpen() {
        boolean ret = this.openCDC();
        if (ret) {
            this.setSyncParams(this.inEndpoint, this.outEndpoint);
            this.asyncMode = false;
            this.isOpen = true;
            this.inputStream = new SerialInputStream(this);
            this.outputStream = new SerialOutputStream(this);
            return true;
        }
        this.isOpen = false;
        return false;
    }

    @Override
    public void syncClose() {
        this.setControlCommand(34, 0, null);
        this.connection.releaseInterface(this.mInterface);
        this.connection.close();
        this.isOpen = false;
    }

    @Override
    public void setBaudRate(int baudRate) {
        byte[] data = this.getLineCoding();
        data[0] = (byte)(baudRate & 0xFF);
        data[1] = (byte)(baudRate >> 8 & 0xFF);
        data[2] = (byte)(baudRate >> 16 & 0xFF);
        data[3] = (byte)(baudRate >> 24 & 0xFF);
        this.setControlCommand(32, 0, data);
    }

    @Override
    public void setDataBits(int dataBits) {
        byte[] data = this.getLineCoding();
        switch (dataBits) {
            case 5: {
                data[6] = 5;
                break;
            }
            case 6: {
                data[6] = 6;
                break;
            }
            case 7: {
                data[6] = 7;
                break;
            }
            case 8: {
                data[6] = 8;
                break;
            }
            default: {
                return;
            }
        }
        this.setControlCommand(32, 0, data);
    }

    @Override
    public void setStopBits(int stopBits) {
        byte[] data = this.getLineCoding();
        switch (stopBits) {
            case 1: {
                data[4] = 0;
                break;
            }
            case 3: {
                data[4] = 1;
                break;
            }
            case 2: {
                data[4] = 2;
                break;
            }
            default: {
                return;
            }
        }
        this.setControlCommand(32, 0, data);
    }

    @Override
    public void setParity(int parity) {
        byte[] data = this.getLineCoding();
        switch (parity) {
            case 0: {
                data[5] = 0;
                break;
            }
            case 1: {
                data[5] = 1;
                break;
            }
            case 2: {
                data[5] = 2;
                break;
            }
            case 3: {
                data[5] = 3;
                break;
            }
            case 4: {
                data[5] = 4;
                break;
            }
            default: {
                return;
            }
        }
        this.setControlCommand(32, 0, data);
    }

    @Override
    public void setFlowControl(int flowControl) {
    }

    @Override
    public void setRTS(boolean state) {
        this.controlLineState = state ? (this.controlLineState |= 2) : (this.controlLineState &= 0xFFFFFFFD);
        this.setControlCommand(34, this.controlLineState, null);
    }

    @Override
    public void setDTR(boolean state) {
        this.controlLineState = state ? (this.controlLineState |= 1) : (this.controlLineState &= 0xFFFFFFFE);
        this.setControlCommand(34, this.controlLineState, null);
    }

    @Override
    public void getCTS(UsbSerialInterface.UsbCTSCallback ctsCallback) {
    }

    @Override
    public void getDSR(UsbSerialInterface.UsbDSRCallback dsrCallback) {
    }

    @Override
    public void getBreak(UsbSerialInterface.UsbBreakCallback breakCallback) {
    }

    @Override
    public void getFrame(UsbSerialInterface.UsbFrameCallback frameCallback) {
    }

    @Override
    public void getOverrun(UsbSerialInterface.UsbOverrunCallback overrunCallback) {
    }

    @Override
    public void getParity(UsbSerialInterface.UsbParityCallback parityCallback) {
    }

    private boolean openCDC() {
        if (!this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
            return false;
        }
        Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            if (endpoint.getType() != 2 || endpoint.getDirection() != 0) continue;
            this.outEndpoint = endpoint;
        }
        if (this.outEndpoint == null || this.inEndpoint == null) {
            Log.i((String)CLASS_ID, (String)"Interface does not have an IN or OUT interface");
            return false;
        }
        this.setControlCommand(32, 0, this.getInitialLineCoding());
        this.setControlCommand(34, 3, null);
        return true;
    }

    protected byte[] getInitialLineCoding() {
        byte[] lineCoding;
        int initialBaudRate = this.getInitialBaudRate();
        if (initialBaudRate > 0) {
            lineCoding = (byte[])CDC_DEFAULT_LINE_CODING.clone();
            for (int i = 0; i < 4; ++i) {
                lineCoding[i] = (byte)(initialBaudRate >> i * 8 & 0xFF);
            }
        } else {
            lineCoding = CDC_DEFAULT_LINE_CODING;
        }
        return lineCoding;
    }

    private int setControlCommand(int request, int value, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(33, request, value, 0, data, dataLength, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    private byte[] getLineCoding() {
        byte[] data = new byte[7];
        int response = this.connection.controlTransfer(161, 33, 0, 0, data, data.length, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return data;
    }

    private static int findFirstCDC(UsbDevice device) {
        int interfaceCount = device.getInterfaceCount();
        for (int iIndex = 0; iIndex < interfaceCount; ++iIndex) {
            if (device.getInterface(iIndex).getInterfaceClass() != 10) continue;
            return iIndex;
        }
        Log.i((String)CLASS_ID, (String)"There is no CDC class interface");
        return -1;
    }
}

