/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.os.Build;
import com.felhr.deviceids.CH34xIds;
import com.felhr.deviceids.CP210xIds;
import com.felhr.deviceids.FTDISioIds;
import com.felhr.deviceids.PL2303Ids;
import com.felhr.usbserial.CDCSerialDevice;
import com.felhr.usbserial.CH34xSerialDevice;
import com.felhr.usbserial.CP2102SerialDevice;
import com.felhr.usbserial.FTDISerialDevice;
import com.felhr.usbserial.PL2303SerialDevice;
import com.felhr.usbserial.SerialBuffer;
import com.felhr.usbserial.UsbSerialInterface;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class UsbSerialDevice
implements UsbSerialInterface {
    private static final String CLASS_ID = UsbSerialDevice.class.getSimpleName();
    private static boolean mr1Version = Build.VERSION.SDK_INT > 17;
    protected final UsbDevice device;
    protected final UsbDeviceConnection connection;
    protected static final int USB_TIMEOUT = 5000;
    protected SerialBuffer serialBuffer;
    protected WorkerThread workerThread;
    protected WriteThread writeThread;
    protected ReadThread readThread;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    protected boolean asyncMode;

    public UsbSerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        this.device = device;
        this.connection = connection;
        this.asyncMode = true;
        this.serialBuffer = new SerialBuffer(mr1Version);
    }

    public static UsbSerialDevice createUsbSerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        return UsbSerialDevice.createUsbSerialDevice(device, connection, -1);
    }

    public static UsbSerialDevice createUsbSerialDevice(UsbDevice device, UsbDeviceConnection connection, int iface) {
        int pid;
        int vid = device.getVendorId();
        if (FTDISioIds.isDeviceSupported(vid, pid = device.getProductId())) {
            return new FTDISerialDevice(device, connection, iface);
        }
        if (CP210xIds.isDeviceSupported(vid, pid)) {
            return new CP2102SerialDevice(device, connection, iface);
        }
        if (PL2303Ids.isDeviceSupported(vid, pid)) {
            return new PL2303SerialDevice(device, connection, iface);
        }
        if (CH34xIds.isDeviceSupported(vid, pid)) {
            return new CH34xSerialDevice(device, connection, iface);
        }
        if (UsbSerialDevice.isCdcDevice(device)) {
            return new CDCSerialDevice(device, connection, iface);
        }
        return null;
    }

    public static boolean isSupported(UsbDevice device) {
        int pid;
        int vid = device.getVendorId();
        if (FTDISioIds.isDeviceSupported(vid, pid = device.getProductId())) {
            return true;
        }
        if (CP210xIds.isDeviceSupported(vid, pid)) {
            return true;
        }
        if (PL2303Ids.isDeviceSupported(vid, pid)) {
            return true;
        }
        if (CH34xIds.isDeviceSupported(vid, pid)) {
            return true;
        }
        return UsbSerialDevice.isCdcDevice(device);
    }

    @Override
    public abstract boolean open();

    @Override
    public void write(byte[] buffer) {
        if (this.asyncMode) {
            this.serialBuffer.putWriteBuffer(buffer);
        }
    }

    @Override
    public int read(UsbSerialInterface.UsbReadCallback mCallback) {
        if (!this.asyncMode) {
            return -1;
        }
        if (mr1Version) {
            if (this.workerThread != null) {
                this.workerThread.setCallback(mCallback);
                this.workerThread.getUsbRequest().queue(this.serialBuffer.getReadBuffer(), 16384);
            }
        } else {
            this.readThread.setCallback(mCallback);
        }
        return 0;
    }

    @Override
    public abstract void close();

    @Override
    public abstract boolean syncOpen();

    @Override
    public abstract void syncClose();

    @Override
    public int syncWrite(byte[] buffer, int timeout) {
        if (!this.asyncMode) {
            if (buffer == null) {
                return 0;
            }
            return this.connection.bulkTransfer(this.outEndpoint, buffer, buffer.length, timeout);
        }
        return -1;
    }

    @Override
    public int syncRead(byte[] buffer, int timeout) {
        if (this.asyncMode) {
            return -1;
        }
        if (buffer == null) {
            return 0;
        }
        return this.connection.bulkTransfer(this.inEndpoint, buffer, buffer.length, timeout);
    }

    @Override
    public abstract void setBaudRate(int var1);

    @Override
    public abstract void setDataBits(int var1);

    @Override
    public abstract void setStopBits(int var1);

    @Override
    public abstract void setParity(int var1);

    @Override
    public abstract void setFlowControl(int var1);

    public void debug(boolean value) {
        if (this.serialBuffer != null) {
            this.serialBuffer.debug(value);
        }
    }

    private boolean isFTDIDevice() {
        return this instanceof FTDISerialDevice;
    }

    public static boolean isCdcDevice(UsbDevice device) {
        int iIndex = device.getInterfaceCount();
        for (int i = 0; i <= iIndex - 1; ++i) {
            UsbInterface iface = device.getInterface(i);
            if (iface.getInterfaceClass() != 10) continue;
            return true;
        }
        return false;
    }

    protected void setSyncParams(UsbEndpoint inEndpoint, UsbEndpoint outEndpoint) {
        this.inEndpoint = inEndpoint;
        this.outEndpoint = outEndpoint;
    }

    protected void setThreadsParams(UsbRequest request, UsbEndpoint endpoint) {
        if (mr1Version) {
            this.workerThread.setUsbRequest(request);
            this.writeThread.setUsbEndpoint(endpoint);
        } else {
            this.readThread.setUsbEndpoint(request.getEndpoint());
            this.writeThread.setUsbEndpoint(endpoint);
        }
    }

    protected void killWorkingThread() {
        if (mr1Version && this.workerThread != null) {
            this.workerThread.stopWorkingThread();
            this.workerThread = null;
        } else if (!mr1Version && this.readThread != null) {
            this.readThread.stopReadThread();
            this.readThread = null;
        }
    }

    protected void restartWorkingThread() {
        block3: {
            block2: {
                if (!mr1Version || this.workerThread != null) break block2;
                this.workerThread = new WorkerThread(this);
                this.workerThread.start();
                while (!this.workerThread.isAlive()) {
                }
                break block3;
            }
            if (mr1Version || this.readThread != null) break block3;
            this.readThread = new ReadThread(this);
            this.readThread.start();
            while (!this.readThread.isAlive()) {
            }
        }
    }

    protected void killWriteThread() {
        if (this.writeThread != null) {
            this.writeThread.stopWriteThread();
            this.writeThread = null;
            this.serialBuffer.resetWriteBuffer();
        }
    }

    protected void restartWriteThread() {
        if (this.writeThread == null) {
            this.writeThread = new WriteThread();
            this.writeThread.start();
            while (!this.writeThread.isAlive()) {
            }
        }
    }

    protected class ReadThread
    extends Thread {
        private UsbSerialDevice usbSerialDevice;
        private UsbSerialInterface.UsbReadCallback callback;
        private UsbEndpoint inEndpoint;
        private AtomicBoolean working;

        public ReadThread(UsbSerialDevice usbSerialDevice) {
            this.usbSerialDevice = usbSerialDevice;
            this.working = new AtomicBoolean(true);
        }

        public void setCallback(UsbSerialInterface.UsbReadCallback callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            byte[] dataReceived = null;
            while (this.working.get()) {
                int numberBytes = this.inEndpoint != null ? UsbSerialDevice.this.connection.bulkTransfer(this.inEndpoint, UsbSerialDevice.this.serialBuffer.getBufferCompatible(), 16384, 0) : 0;
                if (numberBytes <= 0) continue;
                dataReceived = UsbSerialDevice.this.serialBuffer.getDataReceivedCompatible(numberBytes);
                if (UsbSerialDevice.this.isFTDIDevice()) {
                    ((FTDISerialDevice)this.usbSerialDevice).ftdiUtilities.checkModemStatus(dataReceived);
                    if (dataReceived.length <= 2) continue;
                    dataReceived = ((FTDISerialDevice)this.usbSerialDevice).ftdiUtilities.adaptArray(dataReceived);
                    this.onReceivedData(dataReceived);
                    continue;
                }
                this.onReceivedData(dataReceived);
            }
        }

        public void setUsbEndpoint(UsbEndpoint inEndpoint) {
            this.inEndpoint = inEndpoint;
        }

        public void stopReadThread() {
            this.working.set(false);
        }

        private void onReceivedData(byte[] data) {
            if (this.callback != null) {
                this.callback.onReceivedData(data);
            }
        }
    }

    protected class WriteThread
    extends Thread {
        private UsbEndpoint outEndpoint;
        private AtomicBoolean working = new AtomicBoolean(true);

        @Override
        public void run() {
            while (this.working.get()) {
                byte[] data = UsbSerialDevice.this.serialBuffer.getWriteBuffer();
                if (data.length <= 0) continue;
                UsbSerialDevice.this.connection.bulkTransfer(this.outEndpoint, data, data.length, 5000);
            }
        }

        public void setUsbEndpoint(UsbEndpoint outEndpoint) {
            this.outEndpoint = outEndpoint;
        }

        public void stopWriteThread() {
            this.working.set(false);
        }
    }

    protected class WorkerThread
    extends Thread {
        private UsbSerialDevice usbSerialDevice;
        private UsbSerialInterface.UsbReadCallback callback;
        private UsbRequest requestIN;
        private AtomicBoolean working;

        public WorkerThread(UsbSerialDevice usbSerialDevice) {
            this.usbSerialDevice = usbSerialDevice;
            this.working = new AtomicBoolean(true);
        }

        @Override
        public void run() {
            while (this.working.get()) {
                UsbRequest request = UsbSerialDevice.this.connection.requestWait();
                if (request == null || request.getEndpoint().getType() != 2 || request.getEndpoint().getDirection() != 128) continue;
                byte[] data = UsbSerialDevice.this.serialBuffer.getDataReceived();
                if (UsbSerialDevice.this.isFTDIDevice()) {
                    ((FTDISerialDevice)this.usbSerialDevice).ftdiUtilities.checkModemStatus(data);
                    UsbSerialDevice.this.serialBuffer.clearReadBuffer();
                    if (data.length > 2) {
                        data = ((FTDISerialDevice)this.usbSerialDevice).ftdiUtilities.adaptArray(data);
                        this.onReceivedData(data);
                    }
                } else {
                    UsbSerialDevice.this.serialBuffer.clearReadBuffer();
                    this.onReceivedData(data);
                }
                this.requestIN.queue(UsbSerialDevice.this.serialBuffer.getReadBuffer(), 16384);
            }
        }

        public void setCallback(UsbSerialInterface.UsbReadCallback callback) {
            this.callback = callback;
        }

        public void setUsbRequest(UsbRequest request) {
            this.requestIN = request;
        }

        public UsbRequest getUsbRequest() {
            return this.requestIN;
        }

        private void onReceivedData(byte[] data) {
            if (this.callback != null) {
                this.callback.onReceivedData(data);
            }
        }

        public void stopWorkingThread() {
            this.working.set(false);
        }
    }
}

