/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;

@Deprecated
public class BLED112SerialDevice
extends UsbSerialDevice {
    private static final String CLASS_ID = BLED112SerialDevice.class.getSimpleName();
    private static final int BLED112_REQTYPE_HOST2DEVICE = 33;
    private static final int BLED112_REQTYPE_DEVICE2HOST = 161;
    private static final int BLED112_SET_LINE_CODING = 32;
    private static final int BLED112_GET_LINE_CODING = 33;
    private static final int BLED112_SET_CONTROL_LINE_STATE = 34;
    private static final byte[] BLED112_DEFAULT_LINE_CODING = new byte[]{0, 1, -62, 0, 0, 0, 8};
    private static final int BLED112_DEFAULT_CONTROL_LINE = 3;
    private static final int BLED112_DISCONNECT_CONTROL_LINE = 2;
    private UsbInterface mInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private UsbRequest requestIN;

    @Deprecated
    public BLED112SerialDevice(UsbDevice device, UsbDeviceConnection connection) {
        super(device, connection);
        this.mInterface = device.getInterface(1);
    }

    @Override
    public boolean open() {
        this.restartWorkingThread();
        this.restartWriteThread();
        if (this.connection.claimInterface(this.mInterface, true)) {
            Log.i((String)CLASS_ID, (String)"Interface succesfully claimed");
        } else {
            Log.i((String)CLASS_ID, (String)"Interface could not be claimed");
        }
        int numberEndpoints = this.mInterface.getEndpointCount();
        for (int i = 0; i <= numberEndpoints - 1; ++i) {
            UsbEndpoint endpoint = this.mInterface.getEndpoint(i);
            if (endpoint.getType() == 2 && endpoint.getDirection() == 128) {
                this.inEndpoint = endpoint;
                continue;
            }
            this.outEndpoint = endpoint;
        }
        this.setControlCommand(32, 0, BLED112_DEFAULT_LINE_CODING);
        this.setControlCommand(34, 3, null);
        this.requestIN = new UsbRequest();
        this.requestIN.initialize(this.connection, this.inEndpoint);
        this.setThreadsParams(this.requestIN, this.outEndpoint);
        return true;
    }

    @Override
    public void close() {
        this.setControlCommand(34, 2, null);
        this.killWorkingThread();
        this.killWriteThread();
        this.connection.releaseInterface(this.mInterface);
    }

    @Override
    public boolean syncOpen() {
        return false;
    }

    @Override
    public void syncClose() {
    }

    @Override
    public void setBaudRate(int baudRate) {
        byte[] data = this.getLineCoding();
        data[3] = (byte)(baudRate & 0xFF);
        data[2] = (byte)(baudRate >> 8 & 0xFF);
        data[1] = (byte)(baudRate >> 16 & 0xFF);
        data[0] = (byte)(baudRate >> 24 & 0xFF);
        this.setControlCommand(32, 0, data);
    }

    @Override
    public void setDataBits(int dataBits) {
        byte[] data = this.getLineCoding();
        switch (dataBits) {
            case 5: {
                data[6] = 5;
                break;
            }
            case 6: {
                data[6] = 6;
                break;
            }
            case 7: {
                data[6] = 7;
                break;
            }
            case 8: {
                data[6] = 8;
            }
        }
        this.setControlCommand(32, 0, data);
    }

    @Override
    public void setStopBits(int stopBits) {
        byte[] data = this.getLineCoding();
        switch (stopBits) {
            case 1: {
                data[4] = 0;
                break;
            }
            case 3: {
                data[4] = 1;
                break;
            }
            case 2: {
                data[4] = 2;
            }
        }
        this.setControlCommand(32, 0, data);
    }

    @Override
    public void setParity(int parity) {
        byte[] data = this.getLineCoding();
        switch (parity) {
            case 0: {
                data[5] = 0;
                break;
            }
            case 1: {
                data[5] = 1;
                break;
            }
            case 2: {
                data[5] = 2;
                break;
            }
            case 3: {
                data[5] = 3;
                break;
            }
            case 4: {
                data[5] = 4;
            }
        }
        this.setControlCommand(32, 0, data);
    }

    @Override
    public void setRTS(boolean state) {
    }

    @Override
    public void setDTR(boolean state) {
    }

    @Override
    public void setFlowControl(int flowControl) {
    }

    @Override
    public void getCTS(UsbSerialInterface.UsbCTSCallback ctsCallback) {
    }

    @Override
    public void getDSR(UsbSerialInterface.UsbDSRCallback dsrCallback) {
    }

    @Override
    public void getBreak(UsbSerialInterface.UsbBreakCallback breakCallback) {
    }

    @Override
    public void getFrame(UsbSerialInterface.UsbFrameCallback frameCallback) {
    }

    @Override
    public void getOverrun(UsbSerialInterface.UsbOverrunCallback overrunCallback) {
    }

    @Override
    public void getParity(UsbSerialInterface.UsbParityCallback parityCallback) {
    }

    private int setControlCommand(int request, int value, byte[] data) {
        int dataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        int response = this.connection.controlTransfer(33, request, value, 0, data, dataLength, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return response;
    }

    private byte[] getLineCoding() {
        byte[] data = new byte[7];
        int response = this.connection.controlTransfer(161, 33, 0, 0, data, data.length, 5000);
        Log.i((String)CLASS_ID, (String)("Control Transfer Response: " + String.valueOf(response)));
        return data;
    }
}

