/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.Semigroupal;
import cats.effect.kernel.Async;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.syntax.MonadCancelOps$;
import cats.effect.package$;
import cats.effect.syntax.package;
import cats.syntax.MonadErrorRethrowOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.kafka.CommittableOffsetBatch;
import fs2.kafka.CommittableOffsetBatch$;
import fs2.kafka.CommittableProducerRecords;
import fs2.kafka.ConsumerGroupException$;
import fs2.kafka.GenericSerializer;
import fs2.kafka.KafkaProducer$;
import fs2.kafka.ProducerRecord;
import fs2.kafka.TransactionalKafkaProducer;
import fs2.kafka.TransactionalKafkaProducer$;
import fs2.kafka.TransactionalKafkaProducer$TransactionalProducerPartiallyApplied$;
import fs2.kafka.TransactionalProducerSettings;
import fs2.kafka.internal.Blocking;
import fs2.kafka.internal.WithTransactionalProducer;
import fs2.kafka.internal.WithTransactionalProducer$;
import fs2.kafka.internal.converters$;
import fs2.kafka.producer.MkProducer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.producer.Producer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class TransactionalKafkaProducer$ {
    public static final TransactionalKafkaProducer$ MODULE$ = new TransactionalKafkaProducer$();

    public <F, K, V> Resource<F, TransactionalKafkaProducer.WithoutOffsets<F, K, V>> resource(TransactionalProducerSettings<F, K, V> settings, Async<F> F, MkProducer<F> mk) {
        return (Resource)package.all$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3(settings.producerSettings().keySerializer(), settings.producerSettings().valueSerializer(), WithTransactionalProducer$.MODULE$.apply(mk, settings, F))).mapN((Function3 & Serializable)(keySerializer, valueSerializer, withProducer) -> new TransactionalKafkaProducer.WithoutOffsets<F, K, V>(F, (WithTransactionalProducer)withProducer, (GenericSerializer)keySerializer, (GenericSerializer)valueSerializer, settings){
            private final Async F$1;
            private final WithTransactionalProducer withProducer$1;
            private final GenericSerializer keySerializer$1;
            private final GenericSerializer valueSerializer$1;
            private final TransactionalProducerSettings settings$1;

            public F produce(Chunk<CommittableProducerRecords<F, K, V>> records) {
                return this.produceTransactionWithOffsets(records);
            }

            private F produceTransactionWithOffsets(Chunk<CommittableProducerRecords<F, K, V>> records) {
                if (records.isEmpty()) {
                    return (F)this.F$1.pure((Object)Chunk$.MODULE$.empty());
                }
                CommittableOffsetBatch<F> batch = CommittableOffsetBatch$.MODULE$.fromFoldableMap(records, (Function1 & Serializable)x$1 -> x$1.offset(), this.F$1, Chunk$.MODULE$.instance());
                Object consumerGroupId = batch.consumerGroupIdsMissing() || batch.consumerGroupIds().size() != 1 ? this.F$1.raiseError((Object)((Object)ConsumerGroupException$.MODULE$.apply(batch.consumerGroupIds()))) : this.F$1.pure(batch.consumerGroupIds().head());
                return (F)package.all$.MODULE$.toFlatMapOps(consumerGroupId, (FlatMap)this.F$1).flatMap((Function1 & Serializable)groupId -> {
                    Function2 & Serializable sendOffsets = (Function2 & Serializable)(producer, blocking) -> blocking.apply((JFunction0.mcV.sp & Serializable)() -> producer.sendOffsetsToTransaction(converters$.MODULE$.collection().MapHasAsJava(batch.offsets()).asJava(), new ConsumerGroupMetadata(groupId)));
                    return this.produceTransaction((Chunk<ProducerRecord<K, V>>)records.flatMap((Function1 & Serializable)x$2 -> x$2.records()), (Option<Function2<Producer<byte[], byte[]>, Blocking<F>, F>>)new Some((Object)sendOffsets));
                });
            }

            public F produceWithoutOffsets(Chunk<ProducerRecord<K, V>> records) {
                return this.produceTransaction(records, (Option<Function2<Producer<byte[], byte[]>, Blocking<F>, F>>)None$.MODULE$);
            }

            private F produceTransaction(Chunk<ProducerRecord<K, V>> records, Option<Function2<Producer<byte[], byte[]>, Blocking<F>, F>> sendOffsets) {
                return this.withProducer$1.exclusiveAccess((Function2 & Serializable)(producer, blocking) -> MonadCancelOps$.MODULE$.bracketCase$extension(package.all$.MODULE$.monadCancelOps(blocking.apply((JFunction0.mcV.sp & Serializable)() -> producer.beginTransaction()), (MonadCancel)$this.F$1), (Function1 & Serializable)x$3 -> {
                    Object produce = $this.settings$1.producerSettings().failFastProduce() ? package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Async().apply($this.F$1).delay((Function0 & Serializable)() -> Promise$.MODULE$.apply()), (FlatMap)$this.F$1).flatMap((Function1 & Serializable)produceRecordError -> MonadErrorRethrowOps$.MODULE$.rethrow$extension(package.all$.MODULE$.catsSyntaxMonadErrorRethrow(package$.MODULE$.Async().apply($this.F$1).race(package$.MODULE$.Async().apply($this.F$1).fromFutureCancelable(package$.MODULE$.Async().apply($this.F$1).delay((Function0 & Serializable)() -> new Tuple2((Object)produceRecordError.future(), package$.MODULE$.Async().apply($this.F$1).unit()))), this.produceRecords$1(OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId(produceRecordError)), (Chunk)records, (Producer)producer, (Blocking)blocking)), (MonadError)$this.F$1), (MonadError)$this.F$1)) : this.produceRecords$1((Option)None$.MODULE$, (Chunk)records, (Producer)producer, (Blocking)blocking);
                    return sendOffsets.fold((Function0 & Serializable)() -> produce, (Function1 & Serializable)f -> package.all$.MODULE$.toFlatMapOps(produce, (FlatMap)$this.F$1).flatTap((Function1 & Serializable)x$5 -> f.apply(producer, blocking)));
                }, (Function2 & Serializable)(x0$1, x1$1) -> {
                    Outcome outcome;
                    Outcome outcome2;
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null && (outcome2 = (Outcome)tuple2._2()) instanceof Outcome.Succeeded) {
                        return blocking.apply((JFunction0.mcV.sp & Serializable)() -> producer.commitTransaction());
                    }
                    if (tuple2 != null && ((outcome = (Outcome)tuple2._2()) instanceof Outcome.Canceled ? true : outcome instanceof Outcome.Errored)) {
                        return blocking.apply((JFunction0.mcV.sp & Serializable)() -> producer.abortTransaction());
                    }
                    throw new MatchError((Object)tuple2);
                }, (MonadCancel)$this.F$1));
            }

            public F metrics() {
                return this.withProducer$1.blocking((Function1 & Serializable)x$6 -> converters$.MODULE$.collection().MapHasAsScala(x$6.metrics()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            public String toString() {
                return new StringBuilder(27).append("TransactionalKafkaProducer$").append(System.identityHashCode(this)).toString();
            }

            private final Object produceRecords$1(Option produceRecordError, Chunk records$2, Producer producer$2, Blocking blocking$1) {
                return package.all$.MODULE$.toFlatMapOps(records$2.traverse(KafkaProducer$.MODULE$.produceRecord(this.keySerializer$1, this.valueSerializer$1, (Producer<byte[], byte[]>)producer$2, blocking$1, (Option<Promise<Throwable>>)produceRecordError, this.F$1), (Applicative)this.F$1), (FlatMap)this.F$1).flatMap((Function1 & Serializable)x$4 -> package.all$.MODULE$.toTraverseOps(x$4, Chunk$.MODULE$.instance()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)$this.F$1));
            }
            {
                this.F$1 = F$1;
                this.withProducer$1 = withProducer$1;
                this.keySerializer$1 = keySerializer$1;
                this.valueSerializer$1 = valueSerializer$1;
                this.settings$1 = settings$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$metrics$1(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$1(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.Chunk scala.Option org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking ), $anonfun$produceTransaction$10(scala.Function2 org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking fs2.Chunk ), $anonfun$produceTransaction$11(fs2.kafka.internal.Blocking org.apache.kafka.clients.producer.Producer scala.runtime.BoxedUnit cats.effect.kernel.Outcome ), $anonfun$produceTransaction$12(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$13(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$2(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$3(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.Chunk org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking scala.Option scala.runtime.BoxedUnit ), $anonfun$produceTransaction$4(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.Chunk ), $anonfun$produceTransaction$5(), $anonfun$produceTransaction$6(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.Chunk org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking scala.concurrent.Promise ), $anonfun$produceTransaction$7(fs2.kafka.TransactionalKafkaProducer$$anon$1 scala.concurrent.Promise ), $anonfun$produceTransaction$8(java.lang.Object ), $anonfun$produceTransaction$9(fs2.kafka.TransactionalKafkaProducer$$anon$1 java.lang.Object org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking scala.Function2 ), $anonfun$produceTransactionWithOffsets$1(fs2.kafka.CommittableProducerRecords ), $anonfun$produceTransactionWithOffsets$2(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.kafka.CommittableOffsetBatch fs2.Chunk java.lang.String ), $anonfun$produceTransactionWithOffsets$3(fs2.kafka.CommittableOffsetBatch java.lang.String org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking ), $anonfun$produceTransactionWithOffsets$4(org.apache.kafka.clients.producer.Producer fs2.kafka.CommittableOffsetBatch java.lang.String ), $anonfun$produceTransactionWithOffsets$5(fs2.kafka.CommittableProducerRecords )}, serializedLambda);
            }
        }, (Functor)Resource$.MODULE$.catsEffectAsyncForResource(F), (Semigroupal)Resource$.MODULE$.catsEffectAsyncForResource(F));
    }

    public <F, K, V> Stream<F, TransactionalKafkaProducer.WithoutOffsets<F, K, V>> stream(TransactionalProducerSettings<F, K, V> settings, Async<F> F, MkProducer<F> mk) {
        return Stream$.MODULE$.resource(this.resource(settings, F, mk), F);
    }

    public <F> boolean apply() {
        return TransactionalKafkaProducer$TransactionalProducerPartiallyApplied$.MODULE$.$lessinit$greater$default$1();
    }

    private <F> MkProducer<F> mkAmbig1() {
        throw new AssertionError((Object)"should not be used");
    }

    private <F> MkProducer<F> mkAmbig2() {
        throw new AssertionError((Object)"should not be used");
    }

    private TransactionalKafkaProducer$() {
    }
}

