/*
 * Decompiled with CFR 0.152.
 */
package com.fcannizzaro.jsoup.annotations;

import com.fcannizzaro.jsoup.annotations.exceptions.AttributeNotFoundException;
import com.fcannizzaro.jsoup.annotations.exceptions.ElementNotFoundException;
import com.fcannizzaro.jsoup.annotations.interfaces.AfterBind;
import com.fcannizzaro.jsoup.annotations.interfaces.Attr;
import com.fcannizzaro.jsoup.annotations.interfaces.Child;
import com.fcannizzaro.jsoup.annotations.interfaces.ForEach;
import com.fcannizzaro.jsoup.annotations.interfaces.Html;
import com.fcannizzaro.jsoup.annotations.interfaces.Items;
import com.fcannizzaro.jsoup.annotations.interfaces.Selector;
import com.fcannizzaro.jsoup.annotations.interfaces.Text;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class JsoupProcessor {
    private static Element element(Element container, String query) {
        Elements select = container.select(query);
        if (select.size() == 0) {
            throw new ElementNotFoundException(query);
        }
        return select.first();
    }

    private static Object valueOf(Element container, AnnotatedElement field) {
        Element el;
        Selector selector = field.getAnnotation(Selector.class);
        Text text = field.getAnnotation(Text.class);
        Child child = field.getAnnotation(Child.class);
        Items items = field.getAnnotation(Items.class);
        Html html = field.getAnnotation(Html.class);
        Attr attr = field.getAnnotation(Attr.class);
        String value = null;
        if (field instanceof Field) {
            Class<?> cz;
            Selector sel;
            Field f = (Field)field;
            if (items != null) {
                ParameterizedType type = (ParameterizedType)f.getGenericType();
                Class cz2 = (Class)type.getActualTypeArguments()[0];
                return JsoupProcessor.fromList(container, cz2);
            }
            if (child != null && (sel = (cz = f.getType()).getAnnotation(Selector.class)) != null) {
                return JsoupProcessor.from(JsoupProcessor.element(container, sel.value()), cz);
            }
        }
        if (selector != null) {
            return JsoupProcessor.element(container, selector.value());
        }
        if (text != null) {
            Element el2 = JsoupProcessor.element(container, text.value());
            if (el2 != null) {
                return el2.text();
            }
        } else if (html != null) {
            Element el3 = JsoupProcessor.element(container, html.value());
            if (el3 != null) {
                return el3.html();
            }
        } else if (attr != null && (el = JsoupProcessor.element(container, attr.query())) != null && (value = el.attr(attr.attr())) == null) {
            throw new AttributeNotFoundException(attr.attr());
        }
        return value;
    }

    public static <T> T from(Element container, Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            for (Field field : clazz.getDeclaredFields()) {
                Object value = JsoupProcessor.valueOf(container, field);
                if (value == null) continue;
                field.setAccessible(true);
                field.set(instance, value);
            }
            Method afterBindMethod = null;
            for (Method method : clazz.getDeclaredMethods()) {
                ForEach forEach = method.getAnnotation(ForEach.class);
                AfterBind afterBind = method.getAnnotation(AfterBind.class);
                method.setAccessible(true);
                Object value = JsoupProcessor.valueOf(container, method);
                if (value != null) {
                    method.invoke(instance, value);
                    continue;
                }
                if (afterBind != null) {
                    afterBindMethod = method;
                    continue;
                }
                if (forEach == null) continue;
                Elements elements = container.select(forEach.value());
                for (int i = 0; i < elements.size(); ++i) {
                    Element element = (Element)elements.get(i);
                    if (method.getParameterTypes().length > 1) {
                        method.invoke(instance, element, i);
                        continue;
                    }
                    method.invoke(instance, element);
                }
            }
            if (afterBindMethod != null) {
                afterBindMethod.invoke(instance, new Object[0]);
            }
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> fromList(Element container, Class<T> clazz) {
        ArrayList<T> items = new ArrayList<T>();
        Selector selector = clazz.getAnnotation(Selector.class);
        if (selector != null) {
            Elements elements = container.select(selector.value());
            for (Element element : elements) {
                items.add(JsoupProcessor.from(element, clazz));
            }
        }
        return items;
    }
}

