/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape.viewhelper;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.view.MotionEvent;
import com.github.fastshape.inter.ClipInter;
import com.github.fastshape.inter.CompleteInter;

public class ClipHelper
implements ClipInter<ClipHelper> {
    protected CompleteInter completeInter;
    protected boolean clipSwitch;
    protected boolean clipBg = true;
    protected boolean clipIsCircle = false;
    protected boolean clipIsAreaClick = true;
    protected boolean clipIgnorePadding = true;
    protected float clipTopLeftRadius;
    protected float clipTopRightRadius;
    protected float clipBottomLeftRadius;
    protected float clipBottomRightRadius;
    protected float clipBorderWidth;
    protected int clipBorderColor;
    protected float clipBorderDashWidth;
    protected float clipBorderDashGap;
    protected int clipBorderDashBgColor;
    protected int clipBorderPhase;
    public Paint clipPaint;
    protected Paint clipBorderPaint;
    protected Paint clipBorderDashBgPaint;
    protected Paint clipClearPaint;
    public Path clipPath;
    private Path tempPath;
    protected Path clipBorderPath;
    protected Region viewRegion;
    protected Region clickRegion;
    protected Shader shader;
    protected PathEffect pathEffect;

    public void onSizeChanged() {
        this.clickRegion = new Region();
        this.clipPaint = new Paint(1);
        this.clipPaint.setStyle(Paint.Style.FILL);
        this.clipBorderPaint = new Paint(1);
        this.clipBorderPaint.setStyle(Paint.Style.STROKE);
        this.clipBorderDashBgPaint = new Paint(1);
        this.clipBorderDashBgPaint.setStyle(Paint.Style.STROKE);
        this.clipClearPaint = new Paint(1);
        this.clipClearPaint.setStyle(Paint.Style.STROKE);
        this.clipClearPaint.setColor(-1);
    }

    public void onRefreshPaint(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom, int w, int h) {
        int left = paddingLeft;
        int top = paddingTop;
        int right = paddingRight;
        int bottom = paddingBottom;
        if (this.clipIgnorePadding) {
            left = 0;
            top = 0;
            right = 0;
            bottom = 0;
        }
        this.viewRegion = new Region(0, 0, w, h);
        this.clipPaint.setColor(-1);
        this.clipPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.clipBorderPaint.setColor(this.clipBorderColor);
        this.clipBorderPaint.setStrokeWidth(this.clipBorderWidth * 2.0f);
        this.clipBorderDashBgPaint.setColor(this.clipBorderDashBgColor);
        this.clipBorderDashBgPaint.setStrokeWidth(this.clipBorderWidth * 2.0f);
        this.clipClearPaint.setStrokeWidth(this.clipBorderWidth * 2.0f);
        if (this.shader != null) {
            this.clipBorderPaint.setShader(this.shader);
        } else {
            this.clipBorderPaint.setShader(null);
        }
        if (this.clipBorderDashWidth > 0.0f && this.clipBorderDashGap > 0.0f) {
            this.pathEffect = new DashPathEffect(new float[]{this.clipBorderDashWidth, this.clipBorderDashGap}, (float)this.clipBorderPhase);
            this.clipBorderPaint.setPathEffect(this.pathEffect);
        } else {
            this.clipBorderPaint.setPathEffect(null);
        }
        this.clipPath = new Path();
        this.clipBorderPath = new Path();
        float[] radius = new float[]{this.clipTopLeftRadius, this.clipTopLeftRadius, this.clipTopRightRadius, this.clipTopRightRadius, this.clipBottomRightRadius, this.clipBottomRightRadius, this.clipBottomLeftRadius, this.clipBottomLeftRadius};
        RectF rectF = new RectF((float)left, (float)top, (float)(w - right), (float)(h - bottom));
        if (this.clipIsCircle) {
            int centerX = (w - left - right) / 2 + left;
            int centerY = (h - top - bottom) / 2 + top;
            int circleRadius = w - left - right > h - top - bottom ? (h - top - bottom) / 2 : (w - left - right) / 2;
            this.clipPath.addCircle((float)centerX, (float)centerY, (float)circleRadius, Path.Direction.CW);
            this.clipBorderPath.addCircle((float)centerX, (float)centerY, (float)circleRadius, Path.Direction.CW);
        } else {
            this.clipPath.addRoundRect(rectF, radius, Path.Direction.CW);
            this.clipBorderPath.addRoundRect(rectF, radius, Path.Direction.CW);
        }
        this.clickRegion.setPath(this.clipPath, this.viewRegion);
        this.clipPath.moveTo(0.0f, 0.0f);
        this.clipPath.moveTo((float)w, (float)h);
        if (this.tempPath == null) {
            this.tempPath = new Path();
        } else {
            this.tempPath.reset();
        }
        this.tempPath.addRect(new RectF(0.0f, 0.0f, (float)w, (float)h), Path.Direction.CW);
        this.clipPath.op(this.tempPath, Path.Op.XOR);
    }

    public void clipBg(Canvas canvas) {
        canvas.drawPath(this.clipPath, this.clipPaint);
    }

    public void dispatchDrawEnd(int saveLayerCount, Canvas canvas) {
        if (this.clipBorderWidth > 0.0f) {
            if (Color.alpha((int)this.clipBorderColor) < 255 || this.pathEffect != null) {
                this.clipClearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
                canvas.drawPath(this.clipBorderPath, this.clipClearPaint);
                this.clipClearPaint.setXfermode(null);
            }
            if (this.clipBorderDashBgColor != 0 && this.pathEffect != null) {
                canvas.drawPath(this.clipBorderPath, this.clipBorderDashBgPaint);
            }
            this.clipBorderPaint.setColor(this.clipBorderColor);
            canvas.drawPath(this.clipBorderPath, this.clipBorderPaint);
        }
        canvas.drawPath(this.clipPath, this.clipPaint);
        if (saveLayerCount > 0) {
            canvas.restoreToCount(saveLayerCount);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        return !this.clipIsAreaClick || this.clickRegion.contains((int)event.getX(), (int)event.getY());
    }

    @Override
    public boolean isClipBg() {
        return this.clipBg;
    }

    @Override
    public ClipHelper setClipBg(boolean clipBg) {
        this.clipBg = clipBg;
        return this;
    }

    public boolean getClipSwitch() {
        return this.clipSwitch;
    }

    public ClipHelper setClipSwitch(boolean clipSwitch) {
        this.clipSwitch = clipSwitch;
        return this;
    }

    public ClipHelper clearClipAttr() {
        this.clipBg = true;
        this.clipIsCircle = false;
        this.clipIsAreaClick = true;
        this.clipIgnorePadding = true;
        this.clipTopLeftRadius = 0.0f;
        this.clipTopRightRadius = 0.0f;
        this.clipBottomLeftRadius = 0.0f;
        this.clipBottomRightRadius = 0.0f;
        this.clipBorderWidth = 0.0f;
        this.clipBorderColor = 0;
        this.clipBorderDashWidth = 0.0f;
        this.clipBorderDashGap = 0.0f;
        this.clipBorderDashBgColor = 0;
        this.clipBorderPhase = 0;
        return this;
    }

    @Override
    public boolean getClipIsCircle() {
        return this.clipIsCircle;
    }

    @Override
    public ClipHelper setClipIsCircle(boolean clipIsCircle) {
        this.clipIsCircle = clipIsCircle;
        return this;
    }

    @Override
    public boolean getClipIsAreaClick() {
        return this.clipIsAreaClick;
    }

    @Override
    public ClipHelper setClipIsAreaClick(boolean clipIsAreaClick) {
        this.clipIsAreaClick = clipIsAreaClick;
        return this;
    }

    @Override
    public boolean isClipIgnorePadding() {
        return this.clipIgnorePadding;
    }

    @Override
    public ClipHelper setClipIgnorePadding(boolean clipIgnorePadding) {
        this.clipIgnorePadding = clipIgnorePadding;
        return this;
    }

    @Override
    public float getClipTopLeftRadius() {
        return this.clipTopLeftRadius;
    }

    @Override
    public ClipHelper setClipTopLeftRadius(float clipTopLeftRadius) {
        this.clipTopLeftRadius = clipTopLeftRadius;
        return this;
    }

    @Override
    public float getClipTopRightRadius() {
        return this.clipTopRightRadius;
    }

    @Override
    public ClipHelper setClipTopRightRadius(float clipTopRightRadius) {
        this.clipTopRightRadius = clipTopRightRadius;
        return this;
    }

    @Override
    public float getClipBottomLeftRadius() {
        return this.clipBottomLeftRadius;
    }

    @Override
    public ClipHelper setClipBottomLeftRadius(float clipBottomLeftRadius) {
        this.clipBottomLeftRadius = clipBottomLeftRadius;
        return this;
    }

    @Override
    public float getClipBottomRightRadius() {
        return this.clipBottomRightRadius;
    }

    @Override
    public ClipHelper setClipBottomRightRadius(float clipBottomRightRadius) {
        this.clipBottomRightRadius = clipBottomRightRadius;
        return this;
    }

    @Override
    public float getClipBorderWidth() {
        return this.clipBorderWidth;
    }

    @Override
    public ClipHelper setClipBorderWidth(float clipBorderWidth) {
        this.clipBorderWidth = clipBorderWidth;
        return this;
    }

    @Override
    public int getClipBorderColor() {
        return this.clipBorderColor;
    }

    @Override
    public ClipHelper setClipBorderColor(int clipBorderColor) {
        this.clipBorderColor = clipBorderColor;
        return this;
    }

    @Override
    public float getClipBorderDashWidth() {
        return this.clipBorderDashWidth;
    }

    @Override
    public ClipHelper setClipBorderDashWidth(float clipBorderDashWidth) {
        this.clipBorderDashWidth = clipBorderDashWidth;
        return this;
    }

    @Override
    public float getClipBorderDashGap() {
        return this.clipBorderDashGap;
    }

    @Override
    public ClipHelper setClipBorderDashGap(float clipBorderDashGap) {
        this.clipBorderDashGap = clipBorderDashGap;
        return this;
    }

    @Override
    public int getClipBorderDashBgColor() {
        return this.clipBorderDashBgColor;
    }

    @Override
    public ClipHelper setClipBorderDashBgColor(int clipBorderDashBgColor) {
        this.clipBorderDashBgColor = clipBorderDashBgColor;
        return this;
    }

    @Override
    public int getClipBorderPhase() {
        return this.clipBorderPhase;
    }

    @Override
    public ClipHelper setClipBorderPhase(int clipBorderPhase) {
        this.clipBorderPhase = clipBorderPhase;
        return this;
    }

    @Override
    public Shader getShader() {
        return this.shader;
    }

    @Override
    public ClipHelper setShader(Shader shader) {
        this.shader = shader;
        return this;
    }

    @Override
    public PathEffect getPathEffect() {
        return this.pathEffect;
    }

    @Override
    public ClipHelper setPathEffect(PathEffect pathEffect) {
        this.pathEffect = pathEffect;
        return this;
    }

    public void completeClip() {
        if (this.completeInter != null) {
            this.completeInter.completeClip();
        }
    }

    public void resetClip() {
        if (this.completeInter != null) {
            this.completeInter.resetClip();
        }
    }
}

