/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import com.github.fastshape.BaseViewHelper;
import com.github.fastshape.R;
import com.github.fastshape.inter.ViewHelperInter;

public class MyLinearLayout
extends LinearLayout {
    private BaseViewHelper viewHelper;

    public MyLinearLayout(Context context) {
        super(context);
        this.init(null);
    }

    public MyLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MyLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public MyLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public BaseViewHelper getViewHelper() {
        return this.viewHelper;
    }

    public void setViewHelper(BaseViewHelper viewHelper) {
        this.viewHelper = viewHelper;
    }

    private void init(AttributeSet attrs) {
        this.viewHelper = new BaseViewHelper((View)this, new ViewHelperInter(){

            @Override
            public void onComplete() {
                MyLinearLayout.this.complete();
            }
        });
        this.initData();
        if (attrs == null) {
            return;
        }
        TypedArray viewNormal = this.getContext().obtainStyledAttributes(attrs, R.styleable.MyLinearLayout);
        this.setAttrForDraw(viewNormal);
        Drawable background = this.getBackground();
        if (background != null) {
            viewNormal.recycle();
            return;
        }
        Drawable drawable_normal = viewNormal.getDrawable(R.styleable.MyLinearLayout_drawable_normal);
        Drawable drawable_press = viewNormal.getDrawable(R.styleable.MyLinearLayout_drawable_press);
        if (drawable_normal != null || drawable_press != null) {
            this.viewHelper.drawable_normal = drawable_normal;
            this.viewHelper.drawable_press = drawable_press;
            if (drawable_normal == null) {
                this.viewHelper.drawable_normal = drawable_press;
            }
            if (drawable_press == null) {
                this.viewHelper.drawable_press = drawable_normal;
            }
            viewNormal.recycle();
            this.complete();
            return;
        }
        this.viewHelper.pressColor = viewNormal.getColor(R.styleable.MyLinearLayout_pressColor, this.viewHelper.getTransparentColor());
        this.viewHelper.allLine = viewNormal.getBoolean(R.styleable.MyLinearLayout_all_line, false);
        this.viewHelper.leftLine = viewNormal.getBoolean(R.styleable.MyLinearLayout_left_line, false);
        this.viewHelper.topLine = viewNormal.getBoolean(R.styleable.MyLinearLayout_top_line, false);
        this.viewHelper.rightLine = viewNormal.getBoolean(R.styleable.MyLinearLayout_right_line, false);
        this.viewHelper.bottomLine = viewNormal.getBoolean(R.styleable.MyLinearLayout_bottom_line, false);
        if (this.viewHelper.leftLine && this.viewHelper.topLine && this.viewHelper.rightLine && this.viewHelper.bottomLine) {
            this.viewHelper.allLine = true;
        }
        if (!this.viewHelper.allLine && (this.viewHelper.leftLine || this.viewHelper.topLine || this.viewHelper.rightLine || this.viewHelper.bottomLine)) {
            this.viewHelper.isPartBorder = true;
        }
        this.viewHelper.shapeType = viewNormal.getInteger(R.styleable.MyLinearLayout_shapeType, 0);
        this.viewHelper.borderWidth = viewNormal.getDimension(R.styleable.MyLinearLayout_borderWidth, 0.0f);
        this.viewHelper.borderColor = viewNormal.getColor(R.styleable.MyLinearLayout_borderColor, this.viewHelper.getTransparentColor());
        this.viewHelper.borderDashWidth = viewNormal.getDimension(R.styleable.MyLinearLayout_borderDashWidth, 0.0f);
        this.viewHelper.borderDashGap = viewNormal.getDimension(R.styleable.MyLinearLayout_borderDashGap, 0.0f);
        this.viewHelper.solidColor = viewNormal.getColor(R.styleable.MyLinearLayout_solidColor, this.viewHelper.getTransparentColor());
        float radius = viewNormal.getDimension(R.styleable.MyLinearLayout_radius, 0.0f);
        if (radius > 0.0f) {
            this.viewHelper.topLeftRadius = radius;
            this.viewHelper.topRightRadius = radius;
            this.viewHelper.bottomLeftRadius = radius;
            this.viewHelper.bottomRightRadius = radius;
        } else {
            this.viewHelper.topLeftRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_topLeftRadius, 0.0f);
            this.viewHelper.topRightRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_topRightRadius, 0.0f);
            this.viewHelper.bottomLeftRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_bottomLeftRadius, 0.0f);
            this.viewHelper.bottomRightRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_bottomRightRadius, 0.0f);
        }
        this.viewHelper.gradientType = viewNormal.getInteger(R.styleable.MyLinearLayout_gradientType, -1);
        if (this.viewHelper.gradientType != -1) {
            this.viewHelper.angle = viewNormal.getInteger(R.styleable.MyLinearLayout_gradientAngle, 0);
            this.viewHelper.centerX = viewNormal.getFloat(R.styleable.MyLinearLayout_gradientCenterX, 0.5f);
            this.viewHelper.centerY = viewNormal.getFloat(R.styleable.MyLinearLayout_gradientCenterY, 0.5f);
            this.viewHelper.startColor = viewNormal.getColor(R.styleable.MyLinearLayout_gradientStartColor, 0);
            this.viewHelper.centerColor = viewNormal.getColor(R.styleable.MyLinearLayout_gradientCenterColor, 0);
            this.viewHelper.endColor = viewNormal.getColor(R.styleable.MyLinearLayout_gradientEndColor, 0);
            this.viewHelper.gradientRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_gradientRadius, 40.0f);
        }
        viewNormal.recycle();
        this.complete();
    }

    private void initData() {
        this.viewHelper.clipBorderColor = Color.parseColor((String)"#34e8a6");
        this.viewHelper.clipBorderDashBgColor = -1;
    }

    private void setAttrForDraw(TypedArray viewNormal) {
        float clipRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_clipRadius, 0.0f);
        if (clipRadius > 0.0f) {
            this.viewHelper.clipTopLeftRadius = clipRadius;
            this.viewHelper.clipTopRightRadius = clipRadius;
            this.viewHelper.clipBottomLeftRadius = clipRadius;
            this.viewHelper.clipBottomRightRadius = clipRadius;
        } else {
            this.viewHelper.clipTopLeftRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_clipTopLeftRadius, 0.0f);
            this.viewHelper.clipTopRightRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_clipTopRightRadius, 0.0f);
            this.viewHelper.clipBottomLeftRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_clipBottomLeftRadius, 0.0f);
            this.viewHelper.clipBottomRightRadius = viewNormal.getDimension(R.styleable.MyLinearLayout_clipBottomRightRadius, 0.0f);
        }
        this.viewHelper.clipIgnorePadding = viewNormal.getBoolean(R.styleable.MyLinearLayout_clipIgnorePadding, false);
        this.viewHelper.clipIsCircle = viewNormal.getBoolean(R.styleable.MyLinearLayout_clipIsCircle, false);
        this.viewHelper.clipIsAreaClick = viewNormal.getBoolean(R.styleable.MyLinearLayout_clipIsAreaClick, true);
        this.viewHelper.clipBorderWidth = viewNormal.getDimension(R.styleable.MyLinearLayout_clipBorderWidth, 0.0f);
        this.viewHelper.clipBorderColor = viewNormal.getColor(R.styleable.MyLinearLayout_clipBorderColor, Color.parseColor((String)"#34e8a6"));
        this.viewHelper.clipBorderDashBgColor = viewNormal.getColor(R.styleable.MyLinearLayout_clipBorderDashBgColor, -1);
        this.viewHelper.clipBorderDashWidth = viewNormal.getDimension(R.styleable.MyLinearLayout_clipBorderDashWidth, 0.0f);
        this.viewHelper.clipBorderDashGap = viewNormal.getDimension(R.styleable.MyLinearLayout_clipBorderDashGap, 0.0f);
    }

    public void complete() {
        this.viewHelper.viewComplete((View)this);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.viewHelper != null) {
            this.viewHelper.onSizeChanged(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom(), w, h, oldw, oldh);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.viewHelper != null) {
            this.viewHelper.onRefreshPaint(canvas, this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom(), this.getWidth(), this.getHeight());
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        int saveLayer = canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), null, 31);
        super.dispatchDraw(canvas);
        this.viewHelper.dispatchDrawEnd(saveLayer, canvas);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1 && this.viewHelper != null && this.viewHelper.clipIsAreaClick && !this.viewHelper.onTouchEvent(ev)) {
            return false;
        }
        return super.dispatchTouchEvent(ev);
    }
}

