/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.github.fastshape.BaseViewHelper;
import com.github.fastshape.R;
import com.github.fastshape.inter.ViewHelperInter;

public class MyTextView
extends TextView {
    private BaseViewHelper viewHelper;

    public MyTextView(Context context) {
        super(context);
        this.init(null);
    }

    public MyTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MyTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public BaseViewHelper getViewHelper() {
        return this.viewHelper;
    }

    public void setViewHelper(BaseViewHelper viewHelper) {
        this.viewHelper = viewHelper;
    }

    private void init(AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        this.viewHelper = new BaseViewHelper(new ViewHelperInter(){

            @Override
            public void onComplete() {
                MyTextView.this.complete();
            }
        });
        Drawable background = this.getBackground();
        if (background != null) {
            return;
        }
        TypedArray viewNormal = this.getContext().obtainStyledAttributes(attrs, R.styleable.MyTextView);
        Drawable drawable_normal = viewNormal.getDrawable(R.styleable.MyTextView_drawable_normal);
        Drawable drawable_press = viewNormal.getDrawable(R.styleable.MyTextView_drawable_press);
        this.viewHelper.left_width = (int)viewNormal.getDimension(R.styleable.MyTextView_left_width, -1.0f);
        this.viewHelper.left_height = (int)viewNormal.getDimension(R.styleable.MyTextView_left_height, -1.0f);
        this.viewHelper.top_width = (int)viewNormal.getDimension(R.styleable.MyTextView_top_width, -1.0f);
        this.viewHelper.top_height = (int)viewNormal.getDimension(R.styleable.MyTextView_top_height, -1.0f);
        this.viewHelper.right_width = (int)viewNormal.getDimension(R.styleable.MyTextView_right_width, -1.0f);
        this.viewHelper.right_height = (int)viewNormal.getDimension(R.styleable.MyTextView_right_height, -1.0f);
        this.viewHelper.bottom_width = (int)viewNormal.getDimension(R.styleable.MyTextView_bottom_width, -1.0f);
        this.viewHelper.bottom_height = (int)viewNormal.getDimension(R.styleable.MyTextView_bottom_height, -1.0f);
        if (drawable_normal != null || drawable_press != null) {
            this.viewHelper.drawable_normal = drawable_normal;
            this.viewHelper.drawable_press = drawable_press;
            if (drawable_normal == null) {
                this.viewHelper.drawable_normal = drawable_press;
            }
            if (drawable_press == null) {
                this.viewHelper.drawable_press = drawable_normal;
            }
            viewNormal.recycle();
            this.complete();
            return;
        }
        this.viewHelper.pressColor = viewNormal.getColor(R.styleable.MyTextView_pressColor, this.viewHelper.getTransparentColor());
        this.viewHelper.allLine = viewNormal.getBoolean(R.styleable.MyTextView_all_line, false);
        this.viewHelper.leftLine = viewNormal.getBoolean(R.styleable.MyTextView_left_line, false);
        this.viewHelper.topLine = viewNormal.getBoolean(R.styleable.MyTextView_top_line, false);
        this.viewHelper.rightLine = viewNormal.getBoolean(R.styleable.MyTextView_right_line, false);
        this.viewHelper.bottomLine = viewNormal.getBoolean(R.styleable.MyTextView_bottom_line, false);
        if (this.viewHelper.leftLine && this.viewHelper.topLine && this.viewHelper.rightLine && this.viewHelper.bottomLine) {
            this.viewHelper.allLine = true;
        }
        if (!this.viewHelper.allLine && (this.viewHelper.leftLine || this.viewHelper.topLine || this.viewHelper.rightLine || this.viewHelper.bottomLine)) {
            this.viewHelper.isPartBorder = true;
        }
        this.viewHelper.shapeType = viewNormal.getInteger(R.styleable.MyTextView_shapeType, 0);
        this.viewHelper.borderWidth = viewNormal.getDimension(R.styleable.MyTextView_borderWidth, 0.0f);
        this.viewHelper.borderColor = viewNormal.getColor(R.styleable.MyTextView_borderColor, this.viewHelper.getTransparentColor());
        this.viewHelper.borderDashWidth = viewNormal.getDimension(R.styleable.MyTextView_borderDashWidth, 0.0f);
        this.viewHelper.borderDashGap = viewNormal.getDimension(R.styleable.MyTextView_borderDashGap, 0.0f);
        this.viewHelper.solidColor = viewNormal.getColor(R.styleable.MyTextView_solidColor, this.viewHelper.getTransparentColor());
        float radius = viewNormal.getDimension(R.styleable.MyTextView_radius, 0.0f);
        if (radius > 0.0f) {
            this.viewHelper.topLeftRadius = radius;
            this.viewHelper.topRightRadius = radius;
            this.viewHelper.bottomLeftRadius = radius;
            this.viewHelper.bottomRightRadius = radius;
        } else {
            this.viewHelper.topLeftRadius = viewNormal.getDimension(R.styleable.MyTextView_topLeftRadius, 0.0f);
            this.viewHelper.topRightRadius = viewNormal.getDimension(R.styleable.MyTextView_topRightRadius, 0.0f);
            this.viewHelper.bottomLeftRadius = viewNormal.getDimension(R.styleable.MyTextView_bottomLeftRadius, 0.0f);
            this.viewHelper.bottomRightRadius = viewNormal.getDimension(R.styleable.MyTextView_bottomRightRadius, 0.0f);
        }
        this.viewHelper.gradientType = viewNormal.getInteger(R.styleable.MyTextView_gradientType, -1);
        if (this.viewHelper.gradientType != -1) {
            this.viewHelper.angle = viewNormal.getInteger(R.styleable.MyTextView_gradientAngle, 0);
            this.viewHelper.centerX = viewNormal.getFloat(R.styleable.MyTextView_gradientCenterX, 0.5f);
            this.viewHelper.centerY = viewNormal.getFloat(R.styleable.MyTextView_gradientCenterY, 0.5f);
            this.viewHelper.startColor = viewNormal.getColor(R.styleable.MyTextView_gradientStartColor, 0);
            this.viewHelper.centerColor = viewNormal.getColor(R.styleable.MyTextView_gradientCenterColor, 0);
            this.viewHelper.endColor = viewNormal.getColor(R.styleable.MyTextView_gradientEndColor, 0);
            this.viewHelper.gradientRadius = viewNormal.getDimension(R.styleable.MyTextView_gradientRadius, 40.0f);
        }
        viewNormal.recycle();
        this.complete();
    }

    public void complete() {
        this.viewHelper.viewComplete((View)this);
    }
}

