/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.github.fastshape.BaseViewHelper;
import com.github.fastshape.R;
import com.github.fastshape.inter.ViewHelperInter;

public class MyImageView
extends ImageView {
    private BaseViewHelper viewHelper;

    public MyImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public MyImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MyImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public BaseViewHelper getViewHelper() {
        return this.viewHelper;
    }

    private void init(Context context, AttributeSet attrs) {
        this.viewHelper = new BaseViewHelper((View)this, new ViewHelperInter(){

            @Override
            public void onComplete() {
                MyImageView.this.complete();
            }
        });
        this.initData();
        if (attrs == null) {
            return;
        }
        TypedArray viewNormal = context.obtainStyledAttributes(attrs, R.styleable.MyImageView);
        this.setAttrForDraw(viewNormal);
    }

    public void complete() {
        this.viewHelper.viewComplete((View)this);
    }

    private void initData() {
        this.viewHelper.clipBorderColor = Color.parseColor((String)"#34e8a6");
        this.viewHelper.clipBorderDashBgColor = -1;
    }

    private void setAttrForDraw(TypedArray viewNormal) {
        float clipRadius = viewNormal.getDimension(R.styleable.MyImageView_clipRadius, 0.0f);
        if (clipRadius > 0.0f) {
            this.viewHelper.clipTopLeftRadius = clipRadius;
            this.viewHelper.clipTopRightRadius = clipRadius;
            this.viewHelper.clipBottomLeftRadius = clipRadius;
            this.viewHelper.clipBottomRightRadius = clipRadius;
        } else {
            this.viewHelper.clipTopLeftRadius = viewNormal.getDimension(R.styleable.MyImageView_clipTopLeftRadius, 0.0f);
            this.viewHelper.clipTopRightRadius = viewNormal.getDimension(R.styleable.MyImageView_clipTopRightRadius, 0.0f);
            this.viewHelper.clipBottomLeftRadius = viewNormal.getDimension(R.styleable.MyImageView_clipBottomLeftRadius, 0.0f);
            this.viewHelper.clipBottomRightRadius = viewNormal.getDimension(R.styleable.MyImageView_clipBottomRightRadius, 0.0f);
        }
        this.viewHelper.clipIgnorePadding = viewNormal.getBoolean(R.styleable.MyImageView_clipIgnorePadding, false);
        this.viewHelper.clipIsCircle = viewNormal.getBoolean(R.styleable.MyImageView_clipIsCircle, false);
        this.viewHelper.clipIsAreaClick = viewNormal.getBoolean(R.styleable.MyImageView_clipIsAreaClick, true);
        this.viewHelper.clipBorderWidth = viewNormal.getDimension(R.styleable.MyImageView_clipBorderWidth, 0.0f);
        this.viewHelper.clipBorderColor = viewNormal.getColor(R.styleable.MyImageView_clipBorderColor, Color.parseColor((String)"#34e8a6"));
        this.viewHelper.clipBorderDashBgColor = viewNormal.getColor(R.styleable.MyImageView_clipBorderDashBgColor, -1);
        this.viewHelper.clipBorderDashWidth = viewNormal.getDimension(R.styleable.MyImageView_clipBorderDashWidth, 0.0f);
        this.viewHelper.clipBorderDashGap = viewNormal.getDimension(R.styleable.MyImageView_clipBorderDashGap, 0.0f);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.viewHelper != null) {
            this.viewHelper.onSizeChanged(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom(), w, h, oldw, oldh);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.viewHelper != null) {
            this.viewHelper.onRefreshPaint(canvas, this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom(), this.getWidth(), this.getHeight());
        }
        int saveLayer = canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), null, 31);
        super.onDraw(canvas);
        this.viewHelper.dispatchDrawEnd(saveLayer, canvas);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1 && this.viewHelper != null && this.viewHelper.clipIsAreaClick && !this.viewHelper.onTouchEvent(ev)) {
            return false;
        }
        return super.dispatchTouchEvent(ev);
    }
}

