/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.github.fastshape.Helper;
import com.github.fastshape.MyButton;
import com.github.fastshape.inter.OnDrawInter;
import com.github.fastshape.inter.ViewHelperInter;

public class BaseViewHelper
extends Helper
implements OnDrawInter {
    private ViewHelperInter viewHelperInter;
    private View view;
    public static final int shapeType_rectangle = 0;
    public static final int shapeType_oval = 1;
    public static final int shapeType_line = 2;
    public static final int shapeType_ring = 3;
    protected Integer shapeType = 0;
    protected boolean useLevel;
    protected boolean isPartBorder;
    protected boolean allLine;
    protected boolean leftLine;
    protected boolean topLine;
    protected boolean rightLine;
    protected boolean bottomLine;
    protected float borderWidth;
    protected int solidColor;
    protected int pressColor;
    protected int borderColor;
    protected float borderDashWidth;
    protected float borderDashGap;
    protected float topLeftRadius;
    protected float topRightRadius;
    protected float bottomLeftRadius;
    protected float bottomRightRadius;
    protected int[] partBorderWidth;
    protected Drawable drawable_normal;
    protected Drawable drawable_press;
    protected Integer angle = 0;
    protected float centerX;
    protected float centerY;
    protected int startColor;
    protected int centerColor;
    protected int endColor;
    protected float gradientRadius;
    public static final int gradientType_linear = 0;
    public static final int gradientType_radial = 1;
    public static final int gradientType_sweep = 2;
    protected Integer gradientType = 0;
    protected int errorLayerCount = -100;
    protected Paint clipPaint;
    protected Paint clipBorderPaint;
    protected Paint clipBorderDashBgPaint;
    protected Path clipPath;
    protected Path clipBorderPath;
    protected Region viewRegion;
    protected Region clickRegion;
    protected boolean clipIsCircle = false;
    protected boolean clipIsAreaClick = true;
    protected boolean clipIgnorePadding = false;
    protected float clipTopLeftRadius;
    protected float clipTopRightRadius;
    protected float clipBottomLeftRadius;
    protected float clipBottomRightRadius;
    protected float clipBorderWidth;
    protected int clipBorderColor;
    protected float clipBorderDashWidth;
    protected float clipBorderDashGap;
    protected int clipBorderDashBgColor;
    protected float clipBorderPhase = 1.0f;
    protected Shader shader;
    private boolean needInvalidate;

    public BaseViewHelper() {
        this(null);
    }

    public BaseViewHelper(ViewHelperInter inter) {
        this.viewHelperInter = inter;
    }

    public BaseViewHelper(View view, ViewHelperInter inter) {
        this.viewHelperInter = inter;
        this.view = view;
    }

    public void complete() {
        if (this.viewHelperInter != null) {
            this.viewHelperInter.onComplete();
            if (this.needInvalidate && this.view != null) {
                this.view.invalidate();
                this.needInvalidate = false;
            }
        }
    }

    public BaseViewHelper setShapeType(Integer shapeType) {
        this.shapeType = shapeType;
        return this;
    }

    public BaseViewHelper setUseLevel(boolean useLevel) {
        this.useLevel = useLevel;
        return this;
    }

    public BaseViewHelper setAllLine(boolean allLine) {
        this.allLine = allLine;
        return this;
    }

    public BaseViewHelper setLeftLine(boolean leftLine) {
        this.leftLine = leftLine;
        return this;
    }

    public BaseViewHelper setTopLine(boolean topLine) {
        this.topLine = topLine;
        return this;
    }

    public BaseViewHelper setRightLine(boolean rightLine) {
        this.rightLine = rightLine;
        return this;
    }

    public BaseViewHelper setBottomLine(boolean bottomLine) {
        this.bottomLine = bottomLine;
        return this;
    }

    public BaseViewHelper setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public BaseViewHelper setSolidColor(@ColorInt int solidColor) {
        this.solidColor = solidColor;
        return this;
    }

    public BaseViewHelper setPressColor(@ColorInt int pressColor) {
        this.pressColor = pressColor;
        return this;
    }

    public BaseViewHelper setBorderColor(@ColorInt int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public BaseViewHelper setBorderDashWidth(float borderDashWidth) {
        this.borderDashWidth = borderDashWidth;
        return this;
    }

    public BaseViewHelper setBorderDashGap(float borderDashGap) {
        this.borderDashGap = borderDashGap;
        return this;
    }

    public BaseViewHelper setRadius(float radius) {
        this.setTopLeftRadius(radius);
        this.setTopRightRadius(radius);
        this.setBottomRightRadius(radius);
        this.setBottomLeftRadius(radius);
        return this;
    }

    public BaseViewHelper setTopLeftRadius(float topLeftRadius) {
        this.topLeftRadius = topLeftRadius;
        return this;
    }

    public BaseViewHelper setTopRightRadius(float topRightRadius) {
        this.topRightRadius = topRightRadius;
        return this;
    }

    public BaseViewHelper setBottomLeftRadius(float bottomLeftRadius) {
        this.bottomLeftRadius = bottomLeftRadius;
        return this;
    }

    public BaseViewHelper setBottomRightRadius(float bottomRightRadius) {
        this.bottomRightRadius = bottomRightRadius;
        return this;
    }

    public BaseViewHelper setDrawable_normal(Drawable drawable_normal) {
        this.drawable_normal = drawable_normal;
        return this;
    }

    public BaseViewHelper setDrawable_press(Drawable drawable_press) {
        this.drawable_press = drawable_press;
        return this;
    }

    public BaseViewHelper setAngle(Integer angle) {
        this.angle = angle;
        return this;
    }

    public BaseViewHelper setCenterX(float centerX) {
        this.centerX = centerX;
        return this;
    }

    public BaseViewHelper setCenterY(float centerY) {
        this.centerY = centerY;
        return this;
    }

    public BaseViewHelper setStartColor(int startColor) {
        this.startColor = startColor;
        return this;
    }

    public BaseViewHelper setCenterColor(@ColorInt int centerColor) {
        this.centerColor = centerColor;
        return this;
    }

    public BaseViewHelper setEndColor(@ColorInt int endColor) {
        this.endColor = endColor;
        return this;
    }

    public BaseViewHelper setGradientRadius(float gradientRadius) {
        this.gradientRadius = gradientRadius;
        return this;
    }

    public BaseViewHelper setGradientType(Integer gradientType) {
        this.gradientType = gradientType;
        return this;
    }

    public BaseViewHelper clearAttribute() {
        this.drawable_normal = null;
        this.drawable_press = null;
        this.pressColor = this.getTransparentColor();
        this.allLine = false;
        this.leftLine = false;
        this.topLine = false;
        this.rightLine = false;
        this.bottomLine = false;
        this.shapeType = 0;
        this.borderWidth = 0.0f;
        this.borderColor = this.getTransparentColor();
        this.borderDashWidth = 0.0f;
        this.borderDashGap = 0.0f;
        this.solidColor = this.getTransparentColor();
        this.topLeftRadius = 0.0f;
        this.topRightRadius = 0.0f;
        this.bottomLeftRadius = 0.0f;
        this.bottomRightRadius = 0.0f;
        this.gradientType = -1;
        this.angle = 0;
        this.centerX = 0.5f;
        this.centerY = 0.5f;
        this.startColor = 0;
        this.centerColor = 0;
        this.endColor = 0;
        this.gradientRadius = 40.0f;
        return this;
    }

    public Integer getShapeType() {
        return this.shapeType;
    }

    public boolean isUseLevel() {
        return this.useLevel;
    }

    public boolean isAllLine() {
        return this.allLine;
    }

    public boolean isLeftLine() {
        return this.leftLine;
    }

    public boolean isTopLine() {
        return this.topLine;
    }

    public boolean isRightLine() {
        return this.rightLine;
    }

    public boolean isBottomLine() {
        return this.bottomLine;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public int getSolidColor() {
        return this.solidColor;
    }

    public int getPressColor() {
        return this.pressColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public float getBorderDashWidth() {
        return this.borderDashWidth;
    }

    public float getBorderDashGap() {
        return this.borderDashGap;
    }

    public float getTopLeftRadius() {
        return this.topLeftRadius;
    }

    public float getTopRightRadius() {
        return this.topRightRadius;
    }

    public float getBottomLeftRadius() {
        return this.bottomLeftRadius;
    }

    public float getBottomRightRadius() {
        return this.bottomRightRadius;
    }

    public Drawable getDrawable_normal() {
        return this.drawable_normal;
    }

    public Drawable getDrawable_press() {
        return this.drawable_press;
    }

    public Integer getAngle() {
        return this.angle;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public int getStartColor() {
        return this.startColor;
    }

    public int getCenterColor() {
        return this.centerColor;
    }

    public int getEndColor() {
        return this.endColor;
    }

    public float getGradientRadius() {
        return this.gradientRadius;
    }

    public Integer getGradientType() {
        return this.gradientType;
    }

    public GradientDrawable.Orientation getViewOrientation(int angle) {
        GradientDrawable.Orientation orientation = GradientDrawable.Orientation.LEFT_RIGHT;
        switch (angle) {
            case 0: {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 45: {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 90: {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 135: {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case 180: {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 225: {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 270: {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 315: {
                orientation = GradientDrawable.Orientation.TL_BR;
            }
        }
        return orientation;
    }

    public GradientDrawable getNoPartBorderNoPressColorGradientDrawable(boolean isSetGradientType) {
        GradientDrawable gradientDrawableNormal = new GradientDrawable();
        gradientDrawableNormal.setShape(this.shapeType.intValue());
        if (this.allLine) {
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
            if (this.borderWidth <= 0.0f) {
                this.borderWidth = 1.0f;
            }
        }
        gradientDrawableNormal.setStroke((int)this.borderWidth, this.borderColor, this.borderDashWidth, this.borderDashGap);
        gradientDrawableNormal.setColor(this.solidColor);
        float[] fourRadius = new float[]{this.topLeftRadius, this.topLeftRadius, this.topRightRadius, this.topRightRadius, this.bottomRightRadius, this.bottomRightRadius, this.bottomLeftRadius, this.bottomLeftRadius};
        gradientDrawableNormal.setCornerRadii(fourRadius);
        if (isSetGradientType) {
            this.setGradientType(gradientDrawableNormal);
        }
        return gradientDrawableNormal;
    }

    private void setGradientType(GradientDrawable gradientDrawableNormal) {
        if (this.gradientType != -1) {
            gradientDrawableNormal.setGradientCenter(this.centerX, this.centerY);
            if (Build.VERSION.SDK_INT >= 16) {
                gradientDrawableNormal.setOrientation(this.getViewOrientation(this.angle));
            }
            if (this.centerColor != 0) {
                if (Build.VERSION.SDK_INT >= 16) {
                    gradientDrawableNormal.setColors(new int[]{this.startColor, this.centerColor, this.endColor});
                }
            } else if ((this.startColor != 0 || this.endColor != 0) && Build.VERSION.SDK_INT >= 16) {
                gradientDrawableNormal.setColors(new int[]{this.startColor, this.endColor});
            }
            if (this.gradientType == 1) {
                gradientDrawableNormal.setGradientRadius(this.gradientRadius);
                gradientDrawableNormal.setUseLevel(false);
            }
            gradientDrawableNormal.setGradientType(this.gradientType.intValue());
        }
    }

    public GradientDrawable getHasPartBorderNoPressColorGradientDrawable() {
        GradientDrawable layerDrawable = new GradientDrawable();
        layerDrawable.setShape(this.shapeType.intValue());
        layerDrawable.setStroke((int)this.borderWidth, this.borderColor, this.borderDashWidth, this.borderDashGap);
        layerDrawable.setColor(this.solidColor);
        float[] fourRadius = new float[]{this.topLeftRadius, this.topLeftRadius, this.topRightRadius, this.topRightRadius, this.bottomRightRadius, this.bottomRightRadius, this.bottomLeftRadius, this.bottomLeftRadius};
        layerDrawable.setCornerRadii(fourRadius);
        return layerDrawable;
    }

    public GradientDrawable getHasPartBorderNoPressColorGradientDrawableNormal() {
        GradientDrawable layerGradientDrawableNormal = new GradientDrawable();
        layerGradientDrawableNormal.setShape(this.shapeType.intValue());
        if (this.solidColor == this.getTransparentColor()) {
            layerGradientDrawableNormal.setColor(Color.parseColor((String)"#ffffffff"));
        } else {
            layerGradientDrawableNormal.setColor(this.solidColor);
        }
        float[] fourRadius = new float[]{this.topLeftRadius, this.topLeftRadius, this.topRightRadius, this.topRightRadius, this.bottomRightRadius, this.bottomRightRadius, this.bottomLeftRadius, this.bottomLeftRadius};
        layerGradientDrawableNormal.setCornerRadii(fourRadius);
        return layerGradientDrawableNormal;
    }

    public LayerDrawable getHasPartBorderNoPressColorLayerDrawableNormal() {
        GradientDrawable layerDrawable = this.getHasPartBorderNoPressColorGradientDrawable();
        GradientDrawable layerGradientDrawableNormal = this.getHasPartBorderNoPressColorGradientDrawableNormal();
        Drawable[] layers = new Drawable[]{layerDrawable, layerGradientDrawableNormal};
        LayerDrawable layerDrawableNormal = new LayerDrawable(layers);
        layerDrawableNormal.setLayerInset(1, this.partBorderWidth[0], this.partBorderWidth[1], this.partBorderWidth[2], this.partBorderWidth[3]);
        return layerDrawableNormal;
    }

    protected void viewComplete(View myView) {
        if (this.drawable_normal != null) {
            StateListDrawable stateListDrawableForLayer = new StateListDrawable();
            stateListDrawableForLayer.addState(new int[]{-16842919}, this.drawable_normal);
            stateListDrawableForLayer.addState(new int[]{16842919}, this.drawable_press);
            stateListDrawableForLayer.addState(new int[0], this.drawable_normal);
            if (Build.VERSION.SDK_INT >= 16) {
                myView.setBackground((Drawable)stateListDrawableForLayer);
            } else {
                myView.setBackgroundDrawable((Drawable)stateListDrawableForLayer);
            }
            return;
        }
        if (this.allLine || !this.leftLine && !this.topLine && !this.rightLine && !this.bottomLine) {
            this.isPartBorder = false;
        }
        if (!this.allLine && (this.leftLine || this.topLine || this.rightLine || this.bottomLine)) {
            this.isPartBorder = true;
        }
        if (this.shapeType == 2 && myView.getLayerType() == 0) {
            myView.setLayerType(1, null);
        }
        if (!this.isPartBorder) {
            if (this.pressColor == this.getTransparentColor()) {
                this.noPartBorderNoPressColor(myView);
            } else {
                this.noPartBorderHasPressColor(myView);
            }
        } else if (this.pressColor == this.getTransparentColor()) {
            this.hasPartBorderNoPressColor(myView);
        } else {
            this.hasPartBorderHasPressColor(myView);
        }
        if (myView instanceof MyButton) {
            this.setCompoundDrawables((Button)myView);
        } else {
            this.setCompoundDrawables(myView);
        }
    }

    private void setCompoundDrawables(Button myView) {
        int height;
        int width;
        Drawable drawable0 = myView.getCompoundDrawables()[0];
        Drawable drawable1 = myView.getCompoundDrawables()[1];
        Drawable drawable2 = myView.getCompoundDrawables()[2];
        Drawable drawable3 = myView.getCompoundDrawables()[3];
        if (drawable0 != null) {
            width = drawable0.getIntrinsicWidth();
            height = drawable0.getIntrinsicHeight();
            drawable0.setBounds(0, 0, this.getLeftWH(width, height)[0], this.getLeftWH(width, height)[1]);
        }
        if (drawable1 != null) {
            width = drawable1.getIntrinsicWidth();
            height = drawable1.getIntrinsicHeight();
            drawable1.setBounds(0, 0, this.getTopWH(width, height)[0], this.getTopWH(width, height)[1]);
        }
        if (drawable2 != null) {
            width = drawable2.getIntrinsicWidth();
            height = drawable2.getIntrinsicHeight();
            drawable2.setBounds(0, 0, this.getRightWH(width, height)[0], this.getRightWH(width, height)[1]);
        }
        if (drawable3 != null) {
            width = drawable3.getIntrinsicWidth();
            height = drawable3.getIntrinsicHeight();
            drawable3.setBounds(0, 0, this.getBottomWH(width, height)[0], this.getBottomWH(width, height)[1]);
        }
        myView.setCompoundDrawables(drawable0, drawable1, drawable2, drawable3);
    }

    private void setCompoundDrawables(View view) {
        if (view instanceof TextView) {
            int height;
            int width;
            TextView myView = (TextView)view;
            Drawable drawable0 = myView.getCompoundDrawables()[0];
            Drawable drawable1 = myView.getCompoundDrawables()[1];
            Drawable drawable2 = myView.getCompoundDrawables()[2];
            Drawable drawable3 = myView.getCompoundDrawables()[3];
            if (drawable0 != null) {
                width = drawable0.getIntrinsicWidth();
                height = drawable0.getIntrinsicHeight();
                drawable0.setBounds(0, 0, this.getLeftWH(width, height)[0], this.getLeftWH(width, height)[1]);
            }
            if (drawable1 != null) {
                width = drawable1.getIntrinsicWidth();
                height = drawable1.getIntrinsicHeight();
                drawable1.setBounds(0, 0, this.getTopWH(width, height)[0], this.getTopWH(width, height)[1]);
            }
            if (drawable2 != null) {
                width = drawable2.getIntrinsicWidth();
                height = drawable2.getIntrinsicHeight();
                drawable2.setBounds(0, 0, this.getRightWH(width, height)[0], this.getRightWH(width, height)[1]);
            }
            if (drawable3 != null) {
                width = drawable3.getIntrinsicWidth();
                height = drawable3.getIntrinsicHeight();
                drawable3.setBounds(0, 0, this.getBottomWH(width, height)[0], this.getBottomWH(width, height)[1]);
            }
            myView.setCompoundDrawables(drawable0, drawable1, drawable2, drawable3);
        }
    }

    private void noPartBorderNoPressColor(View myView) {
        GradientDrawable gradientDrawableNormal = this.getNoPartBorderNoPressColorGradientDrawable(true);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)gradientDrawableNormal);
        } else {
            myView.setBackgroundDrawable((Drawable)gradientDrawableNormal);
        }
    }

    private void noPartBorderHasPressColor(View myView) {
        GradientDrawable gradientDrawableNormal = this.getNoPartBorderNoPressColorGradientDrawable(false);
        GradientDrawable gradientDrawablePress = this.getNoPartBorderNoPressColorGradientDrawable(false);
        gradientDrawablePress.setColor(this.pressColor);
        StateListDrawable stateListDrawableForShape = new StateListDrawable();
        stateListDrawableForShape.addState(new int[]{-16842919}, (Drawable)gradientDrawableNormal);
        stateListDrawableForShape.addState(new int[]{16842919}, (Drawable)gradientDrawablePress);
        stateListDrawableForShape.addState(new int[0], (Drawable)gradientDrawableNormal);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)stateListDrawableForShape);
        } else {
            myView.setBackgroundDrawable((Drawable)stateListDrawableForShape);
        }
    }

    private void hasPartBorderNoPressColor(View myView) {
        this.setBorderWidthForPartBorder();
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)this.getHasPartBorderNoPressColorLayerDrawableNormal());
        } else {
            myView.setBackgroundDrawable((Drawable)this.getHasPartBorderNoPressColorLayerDrawableNormal());
        }
    }

    private void hasPartBorderHasPressColor(View myView) {
        this.setBorderWidthForPartBorder();
        GradientDrawable gradientDrawable = this.getHasPartBorderNoPressColorGradientDrawable();
        GradientDrawable gradientDrawableNormal = this.getHasPartBorderNoPressColorGradientDrawableNormal();
        GradientDrawable gradientDrawablePress = this.getHasPartBorderNoPressColorGradientDrawable();
        GradientDrawable gradientDrawableNormalPress = this.getHasPartBorderNoPressColorGradientDrawableNormal();
        gradientDrawableNormalPress.setColor(this.pressColor);
        LayerDrawable layerDrawableNormal = new LayerDrawable(new Drawable[]{gradientDrawable, gradientDrawableNormal});
        layerDrawableNormal.setLayerInset(1, this.partBorderWidth[0], this.partBorderWidth[1], this.partBorderWidth[2], this.partBorderWidth[3]);
        LayerDrawable layerDrawablePress = new LayerDrawable(new Drawable[]{gradientDrawablePress, gradientDrawableNormalPress});
        layerDrawablePress.setLayerInset(1, this.partBorderWidth[0], this.partBorderWidth[1], this.partBorderWidth[2], this.partBorderWidth[3]);
        StateListDrawable stateListDrawableForLayer = new StateListDrawable();
        stateListDrawableForLayer.addState(new int[]{-16842919}, (Drawable)layerDrawableNormal);
        stateListDrawableForLayer.addState(new int[]{16842919}, (Drawable)layerDrawablePress);
        stateListDrawableForLayer.addState(new int[0], (Drawable)layerDrawableNormal);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)stateListDrawableForLayer);
        } else {
            myView.setBackgroundDrawable((Drawable)stateListDrawableForLayer);
        }
    }

    protected int getDefBorderColor() {
        return Color.parseColor((String)"#E2E2E2");
    }

    protected int getDefColor() {
        return Color.parseColor((String)"#00000000");
    }

    protected int getTransparentColor() {
        return Color.parseColor((String)"#00000000");
    }

    protected void setBorderWidthForPartBorder() {
        this.partBorderWidth = new int[]{0, 0, 0, 0};
        if (this.leftLine) {
            if (this.borderWidth == 0.0f) {
                this.borderWidth = 1.0f;
            }
            this.partBorderWidth[0] = (int)this.borderWidth;
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
        }
        if (this.topLine) {
            if (this.borderWidth == 0.0f) {
                this.borderWidth = 1.0f;
            }
            this.partBorderWidth[1] = (int)this.borderWidth;
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
        }
        if (this.rightLine) {
            if (this.borderWidth == 0.0f) {
                this.borderWidth = 1.0f;
            }
            this.partBorderWidth[2] = (int)this.borderWidth;
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
        }
        if (this.bottomLine) {
            if (this.borderWidth == 0.0f) {
                this.borderWidth = 1.0f;
            }
            this.partBorderWidth[3] = (int)this.borderWidth;
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
        }
    }

    public boolean isClipIsCircle() {
        return this.clipIsCircle;
    }

    public BaseViewHelper setClipIsCircle(boolean clipIsCircle) {
        this.clipIsCircle = clipIsCircle;
        this.needInvalidate();
        return this;
    }

    private void needInvalidate() {
        if (!this.needInvalidate) {
            this.needInvalidate = true;
        }
    }

    public boolean isClipIsAreaClick() {
        return this.clipIsAreaClick;
    }

    public BaseViewHelper setClipIsAreaClick(boolean clipIsAreaClick) {
        this.clipIsAreaClick = clipIsAreaClick;
        this.needInvalidate();
        return this;
    }

    public boolean isClipIgnorePadding() {
        return this.clipIgnorePadding;
    }

    public BaseViewHelper setClipIgnorePadding(boolean clipIgnorePadding) {
        this.clipIgnorePadding = clipIgnorePadding;
        this.needInvalidate();
        return this;
    }

    public BaseViewHelper setClipRadius(float clipRadius) {
        this.setClipTopLeftRadius(clipRadius);
        this.setClipTopRightRadius(clipRadius);
        this.setClipBottomRightRadius(clipRadius);
        this.setClipBottomLeftRadius(clipRadius);
        this.needInvalidate();
        return this;
    }

    public float getClipTopLeftRadius() {
        return this.clipTopLeftRadius;
    }

    public BaseViewHelper setClipTopLeftRadius(float clipTopLeftRadius) {
        this.clipTopLeftRadius = clipTopLeftRadius;
        this.needInvalidate();
        return this;
    }

    public float getClipTopRightRadius() {
        return this.clipTopRightRadius;
    }

    public BaseViewHelper setClipTopRightRadius(float clipTopRightRadius) {
        this.clipTopRightRadius = clipTopRightRadius;
        this.needInvalidate();
        return this;
    }

    public float getClipBottomLeftRadius() {
        return this.clipBottomLeftRadius;
    }

    public BaseViewHelper setClipBottomLeftRadius(float clipBottomLeftRadius) {
        this.clipBottomLeftRadius = clipBottomLeftRadius;
        this.needInvalidate();
        return this;
    }

    public float getClipBottomRightRadius() {
        return this.clipBottomRightRadius;
    }

    public BaseViewHelper setClipBottomRightRadius(float clipBottomRightRadius) {
        this.clipBottomRightRadius = clipBottomRightRadius;
        this.needInvalidate();
        return this;
    }

    public float getClipBorderWidth() {
        return this.clipBorderWidth;
    }

    public BaseViewHelper setClipBorderWidth(float clipBorderWidth) {
        this.clipBorderWidth = clipBorderWidth;
        this.needInvalidate();
        return this;
    }

    public int getClipBorderColor() {
        return this.clipBorderColor;
    }

    public BaseViewHelper setClipBorderColor(@ColorInt int clipBorderColor) {
        this.clipBorderColor = clipBorderColor;
        this.needInvalidate();
        return this;
    }

    public int getClipBorderDashBgColor() {
        return this.clipBorderDashBgColor;
    }

    public BaseViewHelper setClipBorderDashBgColor(@ColorInt int clipBorderDashBgColor) {
        this.clipBorderDashBgColor = clipBorderDashBgColor;
        this.needInvalidate();
        return this;
    }

    public float getClipBorderDashWidth() {
        return this.clipBorderDashWidth;
    }

    public BaseViewHelper setClipBorderDashWidth(float clipBorderDashWidth) {
        this.clipBorderDashWidth = clipBorderDashWidth;
        this.needInvalidate();
        return this;
    }

    public float getClipBorderDashGap() {
        return this.clipBorderDashGap;
    }

    public BaseViewHelper setClipBorderDashGap(float clipBorderDashGap) {
        this.clipBorderDashGap = clipBorderDashGap;
        this.needInvalidate();
        return this;
    }

    public Shader getShader() {
        return this.shader;
    }

    public BaseViewHelper setShader(Shader shader) {
        this.shader = shader;
        this.needInvalidate();
        return this;
    }

    public float getClipBorderPhase() {
        return this.clipBorderPhase;
    }

    public BaseViewHelper setClipBorderPhase(float clipBorderPhase) {
        this.clipBorderPhase = clipBorderPhase;
        this.needInvalidate();
        return this;
    }

    @Override
    public void onSizeChanged(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom, int w, int h, int oldw, int oldh) {
        this.clickRegion = new Region();
        this.clipPaint = new Paint(1);
        this.clipPaint.setStyle(Paint.Style.FILL);
        this.clipBorderPaint = new Paint(1);
        this.clipBorderPaint.setStyle(Paint.Style.STROKE);
        this.clipBorderDashBgPaint = new Paint(1);
        this.clipBorderDashBgPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public void onRefreshPaint(Canvas canvas, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom, int w, int h) {
        int left = paddingLeft;
        int top = paddingTop;
        int right = paddingRight;
        int bottom = paddingBottom;
        if (this.clipIgnorePadding) {
            left = 0;
            top = 0;
            right = 0;
            bottom = 0;
        }
        this.viewRegion = new Region(0, 0, w, h);
        this.clipPaint.setColor(-1);
        this.clipPaint.setFilterBitmap(false);
        this.clipPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        this.clipBorderPaint.setColor(this.clipBorderColor);
        this.clipBorderPaint.setStrokeWidth(this.clipBorderWidth * 2.0f);
        this.clipBorderDashBgPaint.setColor(this.clipBorderDashBgColor);
        this.clipBorderDashBgPaint.setStrokeWidth(this.clipBorderWidth * 2.0f);
        if (this.shader != null) {
            this.clipBorderPaint.setShader(this.shader);
        }
        if (this.clipBorderDashWidth > 0.0f && this.clipBorderDashGap > 0.0f) {
            this.clipBorderPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.clipBorderDashWidth, this.clipBorderDashGap}, this.clipBorderPhase));
        } else {
            this.clipBorderPaint.setPathEffect(null);
        }
        this.clipPath = new Path();
        this.clipBorderPath = new Path();
        float[] radius = new float[]{this.clipTopLeftRadius, this.clipTopLeftRadius, this.clipTopRightRadius, this.clipTopRightRadius, this.clipBottomRightRadius, this.clipBottomRightRadius, this.clipBottomLeftRadius, this.clipBottomLeftRadius};
        RectF rectF = new RectF((float)left, (float)top, (float)(w - right), (float)(h - bottom));
        if (this.clipIsCircle) {
            int centerX = (w - left - right) / 2 + left;
            int centerY = (h - top - bottom) / 2 + top;
            int circleRadius = w - left - right > h - top - bottom ? (h - top - bottom) / 2 : (w - left - right) / 2;
            this.clipPath.addCircle((float)centerX, (float)centerY, (float)circleRadius, Path.Direction.CW);
            this.clipBorderPath.addCircle((float)centerX, (float)centerY, (float)circleRadius, Path.Direction.CW);
        } else {
            this.clipPath.addRoundRect(rectF, radius, Path.Direction.CW);
            this.clipBorderPath.addRoundRect(rectF, radius, Path.Direction.CW);
        }
        this.clickRegion.setPath(this.clipPath, this.viewRegion);
        this.clipPath.moveTo(0.0f, 0.0f);
        this.clipPath.moveTo((float)w, (float)h);
    }

    @Override
    public void dispatchDrawEnd(int saveLayer, Canvas canvas) {
        if (this.clipBorderWidth > 0.0f) {
            if (this.clipBorderDashBgColor != 0) {
                canvas.drawPath(this.clipBorderPath, this.clipBorderDashBgPaint);
            }
            canvas.drawPath(this.clipBorderPath, this.clipBorderPaint);
        }
        canvas.drawPath(this.clipPath, this.clipPaint);
        canvas.restore();
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return !this.clipIsAreaClick || this.clickRegion.contains((int)event.getX(), (int)event.getY());
    }
}

