/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.generatorcode.op.db;

import com.github.fartherp.codegenerator.db.AbstractAttributes;
import com.github.fartherp.codegenerator.db.ColumnInfo;
import com.github.fartherp.codegenerator.db.TableInfoWrapper;
import com.github.fartherp.codegenerator.java.Field;
import com.github.fartherp.codegenerator.java.JavaTypeInfo;
import com.github.fartherp.codegenerator.util.JavaBeansUtils;
import java.util.List;

public class OpAttributes
extends AbstractAttributes {
    private JavaTypeInfo bo;
    private JavaTypeInfo dao;
    private JavaTypeInfo daoImpl;
    private JavaTypeInfo service;
    private JavaTypeInfo serviceImpl;
    private String baseRecord;
    private String beanPackage;
    private String XMLMapperPackage;
    private String daoPackage;
    private String daoImplPackage;
    private String servicePackage;
    private String serviceImplPackage;
    private String XmlMapperFileName;
    private String pk;

    public void calculateModelAttributes() {
        String pakkage = this.calculateSqlMapPackage();
        this.setBaseRecord(pakkage);
        this.setXMLMapperPackage();
        this.setBeanPackage();
        this.setDaoPackage();
        this.setDaoImplPackage();
        this.setServicePackage();
        this.setServiceImplPackage();
        this.setBo();
        this.setPk();
        this.setDao();
        this.setDaoImpl();
        this.setService();
        this.setServiceImpl();
    }

    public String calculateSqlMapPackage() {
        return this.context.getTargetPackage();
    }

    public void calculateXmlAttributes() {
        String fileXMLMapperName = this.calculateMyBatis3XmlMapperFileName();
        this.setMyBatis3XmlMapperFileName(fileXMLMapperName);
    }

    public void setXMLMapperPackage() {
        this.XMLMapperPackage = "mapper." + this.tableInfo.getDomainObjectSubPackage();
    }

    public String getXMLMapperPackage() {
        return this.XMLMapperPackage;
    }

    public String getNamespace() {
        return this.baseRecord + ".dao." + this.tableInfo.getDomainObjectName() + "Mapper";
    }

    public void setBeanPackage() {
        this.beanPackage = this.baseRecord + ".domain." + this.tableInfo.getDomainObjectName();
    }

    public void setDaoPackage() {
        this.daoPackage = this.baseRecord + ".dao." + this.tableInfo.getDomainObjectName() + "Mapper";
    }

    public void setDaoImplPackage() {
        this.daoImplPackage = this.baseRecord + ".dao.impl." + this.tableInfo.getDomainObjectName() + "MapperImpl";
    }

    public void setServicePackage() {
        this.servicePackage = this.baseRecord + ".service." + this.tableInfo.getDomainObjectName() + "Service";
    }

    public void setServiceImplPackage() {
        this.serviceImplPackage = this.baseRecord + ".service.impl." + this.tableInfo.getDomainObjectName() + "ServiceImpl";
    }

    public void setBaseRecord(String baseRecord) {
        this.baseRecord = baseRecord;
    }

    public void setMyBatis3XmlMapperFileName(String mybatis3XmlMapperFileName) {
        this.XmlMapperFileName = mybatis3XmlMapperFileName;
    }

    public String getMyBatis3XmlMapperFileName() {
        return this.XmlMapperFileName;
    }

    public void setBo() {
        this.bo = new JavaTypeInfo(this.beanPackage);
    }

    public void setDao() {
        this.dao = new JavaTypeInfo(this.daoPackage);
    }

    public void setDaoImpl() {
        this.daoImpl = new JavaTypeInfo(this.daoImplPackage);
    }

    public void setService() {
        this.service = new JavaTypeInfo(this.servicePackage);
    }

    public void setServiceImpl() {
        this.serviceImpl = new JavaTypeInfo(this.serviceImplPackage);
    }

    public JavaTypeInfo getBo() {
        return this.bo;
    }

    public String getBaseRecord() {
        return this.baseRecord;
    }

    public String getRecordWithBLOBsType() {
        return null;
    }

    public JavaTypeInfo getDao() {
        return this.dao;
    }

    public JavaTypeInfo getDaoImpl() {
        return this.daoImpl;
    }

    public JavaTypeInfo getService() {
        return this.service;
    }

    public JavaTypeInfo getServiceImpl() {
        return this.serviceImpl;
    }

    public void setPk() {
        boolean pk;
        List pkList = this.tableInfoWrapper.getPrimaryKeyColumns();
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(this.bo.getShortName());
        sb.append(", ");
        boolean bl = pk = pkList.size() > 1;
        if (pk) {
            sb.append("HashMap");
        } else {
            for (ColumnInfo pkColumnInfo : pkList) {
                Field field = JavaBeansUtils.getJavaBeansField((ColumnInfo)pkColumnInfo, (TableInfoWrapper)this.tableInfoWrapper);
                sb.append(field.getType().getShortName());
            }
        }
        sb.append('>');
        this.pk = sb.toString();
    }

    public String getPk() {
        return this.pk;
    }
}

