/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanzezhen.security.model;

import com.github.fanzezhen.common.util.BeanConverterUtil;
import com.github.fanzezhen.pojo.dto.SysUserDto;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;

public class SysUserDetail
implements UserDetails,
CredentialsContainer {
    private static final Logger log = LoggerFactory.getLogger(SysUserDetail.class);
    private String id;
    private String username;
    private String password;
    private String nickname;
    private String avatar;
    private String email;
    private String phone;
    private Integer sex;
    private String department;
    private Integer delFlag;
    private Integer status;
    private LocalDateTime lastTime;
    private LocalDateTime createTime;
    private LocalDateTime updateTime;
    private String createUserId;
    private String updateUserId;
    private String appCode;
    private Set<GrantedAuthority> authorities;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;
    private Collection<String> roleNames;
    private Collection<String> roleIds;
    private Collection<Integer> roleTypes;
    private String oldPassword;

    public SysUserDetail(SysUserDto sysUserDto, Collection<? extends GrantedAuthority> authorities) {
        this(true, true, true, true, authorities);
        BeanConverterUtil.copy((Object)sysUserDto, (Object)this);
    }

    public SysUserDetail(Map<String, Object> sysUserMap, Collection<? extends GrantedAuthority> authorities) {
        this(true, true, true, true, authorities);
        this.id = String.valueOf(sysUserMap.get("id"));
        this.username = String.valueOf(sysUserMap.get("username"));
        this.password = String.valueOf(sysUserMap.get("password"));
        this.nickname = String.valueOf(sysUserMap.get("nickname"));
        this.avatar = String.valueOf(sysUserMap.get("avatar"));
        this.email = String.valueOf(sysUserMap.get("email"));
        this.phone = String.valueOf(sysUserMap.get("phone"));
        this.lastTime = sysUserMap.get("last_time") instanceof LocalDateTime ? (LocalDateTime)sysUserMap.get("lastTime") : null;
        this.appCode = String.valueOf(sysUserMap.get("app_code"));
    }

    public SysUserDetail(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        this(username, password, true, true, true, true, authorities);
    }

    public SysUserDetail(boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<? extends GrantedAuthority> authorities) {
        this.enabled = enabled;
        this.accountNonExpired = accountNonExpired;
        this.credentialsNonExpired = credentialsNonExpired;
        this.accountNonLocked = accountNonLocked;
        this.authorities = Collections.unmodifiableSet(SysUserDetail.sortAuthorities(authorities));
    }

    public SysUserDetail(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<? extends GrantedAuthority> authorities) {
        if (username == null || "".equals(username) || password == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.setUsername(username);
        this.setPassword(password);
        this.enabled = enabled;
        this.accountNonExpired = accountNonExpired;
        this.credentialsNonExpired = credentialsNonExpired;
        this.accountNonLocked = accountNonLocked;
        this.authorities = Collections.unmodifiableSet(SysUserDetail.sortAuthorities(authorities));
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    private static SortedSet<GrantedAuthority> sortAuthorities(Collection<? extends GrantedAuthority> authorities) {
        Assert.notNull(authorities, (String)"Cannot pass a null GrantedAuthority collection");
        TreeSet<GrantedAuthority> sortedAuthorities = new TreeSet<GrantedAuthority>(new AuthorityComparator());
        for (GrantedAuthority grantedAuthority : authorities) {
            Assert.notNull((Object)grantedAuthority, (String)"GrantedAuthority list cannot contain any null elements");
            sortedAuthorities.add(grantedAuthority);
        }
        return sortedAuthorities;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.getUsername()).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: ").append(this.enabled).append("; ");
        sb.append("AccountNonExpired: ").append(this.accountNonExpired).append("; ");
        sb.append("credentialsNonExpired: ").append(this.credentialsNonExpired).append("; ");
        sb.append("AccountNonLocked: ").append(this.accountNonLocked).append("; ");
        if (this.authorities != null && !this.authorities.isEmpty()) {
            sb.append("Granted Authorities: ");
            boolean first = true;
            for (GrantedAuthority auth : this.authorities) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(auth);
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }

    public static UserBuilder withUsername(String username) {
        return SysUserDetail.builder().username(username);
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    @Deprecated
    public static UserBuilder withDefaultPasswordEncoder() {
        log.warn("SysUserModel.withDefaultPasswordEncoder() is considered unsafe for production and is only intended for sample applications.");
        PasswordEncoder encoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
        UserBuilder var10000 = SysUserDetail.builder();
        Class<?> c = encoder.getClass();
        return var10000.passwordEncoder(arg_0 -> ((PasswordEncoder)encoder).encode(arg_0));
    }

    public static UserBuilder withUserDetails(UserDetails userDetails) {
        return SysUserDetail.withUsername(userDetails.getUsername()).password(userDetails.getPassword()).accountExpired(!userDetails.isAccountNonExpired()).accountLocked(!userDetails.isAccountNonLocked()).authorities(userDetails.getAuthorities()).credentialsExpired(!userDetails.isCredentialsNonExpired()).disabled(!userDetails.isEnabled());
    }

    public void eraseCredentials() {
        this.setPassword(null);
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public Integer getSex() {
        return this.sex;
    }

    public String getDepartment() {
        return this.department;
    }

    public Integer getDelFlag() {
        return this.delFlag;
    }

    public Integer getStatus() {
        return this.status;
    }

    public LocalDateTime getLastTime() {
        return this.lastTime;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public String getCreateUserId() {
        return this.createUserId;
    }

    public String getUpdateUserId() {
        return this.updateUserId;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Collection<String> getRoleNames() {
        return this.roleNames;
    }

    public Collection<String> getRoleIds() {
        return this.roleIds;
    }

    public Collection<Integer> getRoleTypes() {
        return this.roleTypes;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setLastTime(LocalDateTime lastTime) {
        this.lastTime = lastTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setAuthorities(Set<GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.credentialsNonExpired = credentialsNonExpired;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRoleNames(Collection<String> roleNames) {
        this.roleNames = roleNames;
    }

    public void setRoleIds(Collection<String> roleIds) {
        this.roleIds = roleIds;
    }

    public void setRoleTypes(Collection<Integer> roleTypes) {
        this.roleTypes = roleTypes;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SysUserDetail)) {
            return false;
        }
        SysUserDetail other = (SysUserDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$avatar = this.getAvatar();
        String other$avatar = other.getAvatar();
        if (this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        Integer this$sex = this.getSex();
        Integer other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !((Object)this$sex).equals(other$sex)) {
            return false;
        }
        String this$department = this.getDepartment();
        String other$department = other.getDepartment();
        if (this$department == null ? other$department != null : !this$department.equals(other$department)) {
            return false;
        }
        Integer this$delFlag = this.getDelFlag();
        Integer other$delFlag = other.getDelFlag();
        if (this$delFlag == null ? other$delFlag != null : !((Object)this$delFlag).equals(other$delFlag)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        LocalDateTime this$lastTime = this.getLastTime();
        LocalDateTime other$lastTime = other.getLastTime();
        if (this$lastTime == null ? other$lastTime != null : !((Object)this$lastTime).equals(other$lastTime)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDateTime this$updateTime = this.getUpdateTime();
        LocalDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$createUserId = this.getCreateUserId();
        String other$createUserId = other.getCreateUserId();
        if (this$createUserId == null ? other$createUserId != null : !this$createUserId.equals(other$createUserId)) {
            return false;
        }
        String this$updateUserId = this.getUpdateUserId();
        String other$updateUserId = other.getUpdateUserId();
        if (this$updateUserId == null ? other$updateUserId != null : !this$updateUserId.equals(other$updateUserId)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        Collection<GrantedAuthority> this$authorities = this.getAuthorities();
        Collection<GrantedAuthority> other$authorities = other.getAuthorities();
        if (this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities)) {
            return false;
        }
        if (this.isAccountNonExpired() != other.isAccountNonExpired()) {
            return false;
        }
        if (this.isAccountNonLocked() != other.isAccountNonLocked()) {
            return false;
        }
        if (this.isCredentialsNonExpired() != other.isCredentialsNonExpired()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Collection<String> this$roleNames = this.getRoleNames();
        Collection<String> other$roleNames = other.getRoleNames();
        if (this$roleNames == null ? other$roleNames != null : !((Object)this$roleNames).equals(other$roleNames)) {
            return false;
        }
        Collection<String> this$roleIds = this.getRoleIds();
        Collection<String> other$roleIds = other.getRoleIds();
        if (this$roleIds == null ? other$roleIds != null : !((Object)this$roleIds).equals(other$roleIds)) {
            return false;
        }
        Collection<Integer> this$roleTypes = this.getRoleTypes();
        Collection<Integer> other$roleTypes = other.getRoleTypes();
        if (this$roleTypes == null ? other$roleTypes != null : !((Object)this$roleTypes).equals(other$roleTypes)) {
            return false;
        }
        String this$oldPassword = this.getOldPassword();
        String other$oldPassword = other.getOldPassword();
        return !(this$oldPassword == null ? other$oldPassword != null : !this$oldPassword.equals(other$oldPassword));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SysUserDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $avatar = this.getAvatar();
        result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        Integer $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : ((Object)$sex).hashCode());
        String $department = this.getDepartment();
        result = result * 59 + ($department == null ? 43 : $department.hashCode());
        Integer $delFlag = this.getDelFlag();
        result = result * 59 + ($delFlag == null ? 43 : ((Object)$delFlag).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        LocalDateTime $lastTime = this.getLastTime();
        result = result * 59 + ($lastTime == null ? 43 : ((Object)$lastTime).hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $createUserId = this.getCreateUserId();
        result = result * 59 + ($createUserId == null ? 43 : $createUserId.hashCode());
        String $updateUserId = this.getUpdateUserId();
        result = result * 59 + ($updateUserId == null ? 43 : $updateUserId.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        Collection<GrantedAuthority> $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        result = result * 59 + (this.isAccountNonExpired() ? 79 : 97);
        result = result * 59 + (this.isAccountNonLocked() ? 79 : 97);
        result = result * 59 + (this.isCredentialsNonExpired() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Collection<String> $roleNames = this.getRoleNames();
        result = result * 59 + ($roleNames == null ? 43 : ((Object)$roleNames).hashCode());
        Collection<String> $roleIds = this.getRoleIds();
        result = result * 59 + ($roleIds == null ? 43 : ((Object)$roleIds).hashCode());
        Collection<Integer> $roleTypes = this.getRoleTypes();
        result = result * 59 + ($roleTypes == null ? 43 : ((Object)$roleTypes).hashCode());
        String $oldPassword = this.getOldPassword();
        result = result * 59 + ($oldPassword == null ? 43 : $oldPassword.hashCode());
        return result;
    }

    public SysUserDetail() {
    }

    private static class AuthorityComparator
    implements Comparator<GrantedAuthority>,
    Serializable {
        private static final long serialVersionUID = 510L;

        private AuthorityComparator() {
        }

        @Override
        public int compare(GrantedAuthority g1, GrantedAuthority g2) {
            if (g2.getAuthority() == null) {
                return -1;
            }
            return g1.getAuthority() == null ? 1 : g1.getAuthority().compareTo(g2.getAuthority());
        }
    }

    public static class UserBuilder {
        private String username;
        private String password;
        private List<GrantedAuthority> authorities;
        private boolean accountExpired;
        private boolean accountLocked;
        private boolean credentialsExpired;
        private boolean disabled;
        private Function<String, String> passwordEncoder = password -> password;

        private UserBuilder() {
        }

        public UserBuilder username(String username) {
            Assert.notNull((Object)username, (String)"username cannot be null");
            this.username = username;
            return this;
        }

        public UserBuilder password(String password) {
            Assert.notNull((Object)password, (String)"password cannot be null");
            this.password = password;
            return this;
        }

        public UserBuilder passwordEncoder(Function<String, String> encoder) {
            Assert.notNull(encoder, (String)"encoder cannot be null");
            this.passwordEncoder = encoder;
            return this;
        }

        public UserBuilder roles(String ... roles) {
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>(roles.length);
            int var4 = roles.length;
            for (String role : roles) {
                Assert.isTrue((!role.startsWith("ROLE_") ? 1 : 0) != 0, () -> role + " cannot start with ROLE_ (it is automatically added)");
                authorities.add(new SimpleGrantedAuthority("ROLE_" + role));
            }
            return this.authorities(authorities);
        }

        public UserBuilder authorities(GrantedAuthority ... authorities) {
            return this.authorities(Arrays.asList(authorities));
        }

        public UserBuilder authorities(Collection<? extends GrantedAuthority> authorities) {
            this.authorities = new ArrayList<GrantedAuthority>(authorities);
            return this;
        }

        public UserBuilder authorities(String ... authorities) {
            return this.authorities(AuthorityUtils.createAuthorityList((String[])authorities));
        }

        public UserBuilder accountExpired(boolean accountExpired) {
            this.accountExpired = accountExpired;
            return this;
        }

        public UserBuilder accountLocked(boolean accountLocked) {
            this.accountLocked = accountLocked;
            return this;
        }

        public UserBuilder credentialsExpired(boolean credentialsExpired) {
            this.credentialsExpired = credentialsExpired;
            return this;
        }

        public UserBuilder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public UserDetails build() {
            String encodedPassword = this.passwordEncoder.apply(this.password);
            return new SysUserDetail(this.username, encodedPassword, !this.disabled, !this.accountExpired, !this.credentialsExpired, !this.accountLocked, this.authorities);
        }
    }
}

