/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanzezhen.security.interceptor;

import com.github.fanzezhen.pojo.dto.SysPermissionDto;
import com.github.fanzezhen.security.facade.UserDetailsServiceFacade;
import com.github.fanzezhen.security.property.SecurityProjectProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Component;

@Component
public class InvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    @Resource
    private SecurityProjectProperty securityProjectProperty;
    @Resource
    private UserDetailsServiceFacade userDetailsServiceFacade;
    private HashMap<String, Collection<ConfigAttribute>> map;

    public void loadResourceDefine() {
        this.map = new HashMap();
        for (SysPermissionDto sysPermissionDto : this.userDetailsServiceFacade.listAllPermissionDto(this.securityProjectProperty.APP_CODE)) {
            ArrayList<SecurityConfig> array = new ArrayList<SecurityConfig>();
            SecurityConfig cfg = new SecurityConfig("permission_" + sysPermissionDto.getId());
            array.add(cfg);
            this.map.put(String.valueOf(sysPermissionDto.getOperationUrl()), array);
        }
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (this.map == null) {
            this.loadResourceDefine();
        }
        HttpServletRequest request = ((FilterInvocation)object).getHttpRequest();
        for (String s : this.map.keySet()) {
            String resUrl = s;
            AntPathRequestMatcher matcher = new AntPathRequestMatcher(resUrl);
            if (!matcher.matches(request)) continue;
            return this.map.get(resUrl);
        }
        return null;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

