/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanzezhen.security.interceptor;

import com.github.fanzezhen.common.enums.exception.CommonBizExceptionEnum;
import com.github.fanzezhen.common.exception.ServiceException;
import com.github.fanzezhen.common.util.HttpUtil;
import com.github.fanzezhen.security.property.SecurityProperty;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@Order(value=-2147483648)
@Component
public class DefaultExceptionResolver
implements HandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionResolver.class);
    @Resource
    private SecurityProperty securityProperty;
    private View defaultErrorJsonView = fastJsonViewPresent ? (View)Class.forName("com.alibaba.fastjson.support.spring.FastJsonJsonView").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : new MappingJackson2JsonView();
    private String defaultErrorPageView = "error/error";
    private Map<String, String> exceptionMappings;
    private int errorStatus = 200;
    private static final boolean fastJsonViewPresent = ClassUtils.isPresent((String)"com.alibaba.fastjson.support.spring.FastJsonJsonView", (ClassLoader)DefaultExceptionResolver.class.getClassLoader());

    public void setDefaultErrorJsonView(View defaultErrorJsonView) {
        this.defaultErrorJsonView = defaultErrorJsonView;
    }

    public void setDefaultErrorPageView(String defaultErrorPageView) {
        this.defaultErrorPageView = defaultErrorPageView;
    }

    public void setExceptionMappings(Map<String, String> exceptionMappings) {
        this.exceptionMappings = exceptionMappings;
    }

    public void setErrorStatus(int errorStatus) {
        this.errorStatus = errorStatus;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ModelAndView modelAndView;
        log.error("\u8bf7\u6c42" + request.getRequestURI() + "\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        response.setStatus(this.errorStatus);
        if (this.securityProperty.responseJsonFlag) {
            return this.jsonResponse(request, ex);
        }
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            ResponseBody responseBody = (ResponseBody)handlerMethod.getMethodAnnotation(ResponseBody.class);
            if (responseBody == null) {
                responseBody = (ResponseBody)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), ResponseBody.class);
            }
            modelAndView = responseBody != null || HttpUtil.isAjaxRequest((HttpServletRequest)request) ? this.jsonResponse(request, ex) : this.viewResponse(request, response, ex);
        } else {
            modelAndView = HttpUtil.isAjaxRequest((HttpServletRequest)request) ? this.jsonResponse(request, ex) : this.viewResponse(request, response, ex);
        }
        return modelAndView;
    }

    private ModelAndView jsonResponse(HttpServletRequest request, Exception ex) {
        ModelAndView errorView = new ModelAndView();
        Map<String, Object> error = this.newExceptionResp(request, ex);
        errorView.setView(this.defaultErrorJsonView);
        errorView.addAllObjects(error);
        return errorView;
    }

    private ModelAndView viewResponse(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ModelAndView errorView = new ModelAndView();
        Map<String, Object> error = this.newExceptionResp(request, ex);
        String viewName = this.defaultErrorPageView;
        if (this.exceptionMappings != null && (viewName = this.exceptionMappings.get(ex.getClass().getName())) == null) {
            viewName = this.defaultErrorPageView;
        }
        errorView.setViewName(viewName);
        errorView.addAllObjects(error);
        return errorView;
    }

    public Map<String, Object> newExceptionResp(HttpServletRequest request, Exception exception) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        if (exception instanceof ServiceException) {
            Integer errCode = ((ServiceException)exception).getCode();
            error.put("msg", exception.getMessage());
            error.put("code", errCode);
        } else if (exception instanceof IllegalArgumentException) {
            error.put("msg", exception.getMessage());
            error.put("code", CommonBizExceptionEnum.BizExceptionEnum.ILLEGAL_ARGUMENT_ERROR.getCode());
        } else {
            error.put("msg", CommonBizExceptionEnum.BizExceptionEnum.DEFAULT_ERROR.getMessage());
            error.put("code", CommonBizExceptionEnum.BizExceptionEnum.DEFAULT_ERROR.getCode());
        }
        return error;
    }
}

