/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanzezhen.security;

import com.github.fanzezhen.common.enums.exception.CommonBizExceptionEnum;
import com.github.fanzezhen.common.enums.exception.IExceptionEnum;
import com.github.fanzezhen.common.exception.ServiceException;
import com.github.fanzezhen.security.model.SysUserDetail;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class SysSecurityUtil {
    public static boolean isLoginUser() {
        return SecurityContextHolder.getContext() != null && SysSecurityUtil.getAuthentication() != null;
    }

    public static boolean isGuest() {
        return !SysSecurityUtil.isLoginUser();
    }

    public static Authentication getAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof AnonymousAuthenticationToken)) {
            return authentication;
        }
        return null;
    }

    public static User getUser() {
        if (SysSecurityUtil.getAuthentication() == null) {
            return null;
        }
        UsernamePasswordAuthenticationToken authenticationToken = (UsernamePasswordAuthenticationToken)SysSecurityUtil.getAuthentication();
        User userDetails = (User)authenticationToken.getDetails();
        if (userDetails == null) {
            throw new ServiceException((IExceptionEnum)CommonBizExceptionEnum.BizExceptionEnum.SESSION_TIMEOUT);
        }
        return userDetails;
    }

    public static SysUserDetail getSysUserDetail() {
        if (SysSecurityUtil.getAuthentication() == null) {
            return null;
        }
        try {
            return (SysUserDetail)SysSecurityUtil.getAuthentication().getPrincipal();
        }
        catch (Exception e) {
            throw new ServiceException((IExceptionEnum)CommonBizExceptionEnum.BizExceptionEnum.SESSION_TIMEOUT);
        }
    }

    public static String getLoginUserId() {
        if (SysSecurityUtil.getAuthentication() == null) {
            return null;
        }
        try {
            return ((SysUserDetail)SysSecurityUtil.getAuthentication().getPrincipal()).getId();
        }
        catch (Exception e) {
            throw new ServiceException((IExceptionEnum)CommonBizExceptionEnum.BizExceptionEnum.SESSION_TIMEOUT);
        }
    }

    public static String encrypt(String s) {
        return new BCryptPasswordEncoder().encode((CharSequence)s);
    }

    public static boolean verifyPassword(String rawPassword, String encodedPassword) {
        return new BCryptPasswordEncoder().matches((CharSequence)rawPassword, encodedPassword);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            System.out.println(SysSecurityUtil.encrypt("111111"));
        }
    }
}

