/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.internal.objenesis.strategy;

import com.github.fakemongo.internal.objenesis.ObjenesisException;
import com.github.fakemongo.internal.objenesis.instantiator.ObjectInstantiator;
import com.github.fakemongo.internal.objenesis.instantiator.android.AndroidSerializationInstantiator;
import com.github.fakemongo.internal.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import com.github.fakemongo.internal.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import com.github.fakemongo.internal.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import com.github.fakemongo.internal.objenesis.instantiator.perc.PercSerializationInstantiator;
import com.github.fakemongo.internal.objenesis.strategy.BaseInstantiatorStrategy;
import com.github.fakemongo.internal.objenesis.strategy.PlatformDescription;
import java.io.NotSerializableException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (PlatformDescription.JVM_NAME.startsWith("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine()) {
                return new ObjectInputStreamInstantiator<T>(type);
            }
            return new ObjectStreamClassInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new ObjectStreamClassInstantiator<T>(type);
            }
            return new AndroidSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("PERC")) {
            return new PercSerializationInstantiator<T>(type);
        }
        return new ObjectStreamClassInstantiator<T>(type);
    }
}

