/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.mongodb.BasicDBList;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.ArrayList;
import org.bson.util.annotations.ThreadSafe;

@ThreadSafe
public class Unwind
extends PipelineKeyword {
    public static final Unwind INSTANCE = new Unwind();

    private Unwind() {
    }

    @Override
    public DBCollection apply(DB originalDB, DBCollection coll, DBObject object) {
        String fieldName = object.get(this.getKeyword()).toString();
        if (!fieldName.startsWith("$")) {
            throw new MongoException("");
        }
        fieldName = fieldName.substring(1);
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        for (DBObject dbObject : coll.find().toArray()) {
            if (!Util.containsField(dbObject, fieldName)) continue;
            Object oValue = Util.extractField(dbObject, fieldName);
            if (!(oValue instanceof BasicDBList)) {
                throw new MongoException(15978, "exception: $unwind:  value at end of field path must be an array");
            }
            BasicDBList list = (BasicDBList)oValue;
            for (Object sublist : list) {
                DBObject newValue = Util.clone(dbObject);
                Util.putValue(newValue, fieldName, sublist);
                result.add(newValue);
            }
        }
        return this.dropAndInsert(coll, result);
    }

    @Override
    public String getKeyword() {
        return "$unwind";
    }
}

