/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl;

import com.github.fakemongo.FongoException;
import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Filter;
import com.github.fakemongo.impl.Util;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateEngine {
    static final Logger LOG = LoggerFactory.getLogger(UpdateEngine.class);
    private final ExpressionParser expressionParser = new ExpressionParser();
    final List<BasicUpdate> commands = Arrays.asList(new BasicUpdate("$set", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            subObject.put(subKey, object);
        }
    }, new BasicUpdate("$inc", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            Number updateNumber = UpdateEngine.this.expressionParser.typecast(this.command + " value", object, Number.class);
            Object oldValue = subObject.get(subKey);
            if (oldValue == null) {
                subObject.put(subKey, (Object)updateNumber);
            } else {
                Number oldNumber = UpdateEngine.this.expressionParser.typecast(subKey + " value", oldValue, Number.class);
                subObject.put(subKey, (Object)UpdateEngine.this.genericAdd(oldNumber, updateNumber));
            }
        }
    }, new BasicUpdate("$unset", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            subObject.removeField(subKey);
        }
    }, new BasicUpdate("$rename", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            Object objValue = subObject.removeField(subKey);
            String newKey = (String)object;
            Util.putValue(objOriginal, newKey, objValue);
        }
    }, new BasicUpdate("$push", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            if (!subObject.containsField(subKey)) {
                subObject.put(subKey, (Object)UpdateEngine.this.asDbList(object));
            } else {
                BasicDBList currentValue = UpdateEngine.this.expressionParser.typecast(subKey, subObject.get(subKey), BasicDBList.class);
                currentValue.add(object);
                subObject.put(subKey, (Object)currentValue);
            }
        }
    }, new BasicUpdate("$pushAll", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            List newList = UpdateEngine.this.expressionParser.typecast(this.command + " value", object, List.class);
            if (!subObject.containsField(subKey)) {
                subObject.put(subKey, (Object)newList);
            } else {
                BasicDBList currentValue = UpdateEngine.this.expressionParser.typecast(subKey, subObject.get(subKey), BasicDBList.class);
                currentValue.addAll((Collection)newList);
                subObject.put(subKey, (Object)currentValue);
            }
        }
    }, new BasicUpdate("$addToSet", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            Object eachObject;
            boolean isEach = false;
            BasicDBList currentValue = UpdateEngine.this.expressionParser.typecast(subKey, subObject.get(subKey), BasicDBList.class);
            BasicDBList basicDBList = currentValue = currentValue == null ? new BasicDBList() : currentValue;
            if (object instanceof DBObject && (eachObject = ((DBObject)object).get("$each")) != null) {
                isEach = true;
                BasicDBList newList = UpdateEngine.this.expressionParser.typecast(this.command + ".$each value", eachObject, BasicDBList.class);
                if (newList == null) {
                    throw new FongoException(this.command + ".$each must not be null");
                }
                for (Object newValue : newList) {
                    if (currentValue.contains(newValue)) continue;
                    currentValue.add(newValue);
                }
            }
            if (!isEach && !currentValue.contains(object)) {
                currentValue.add(object);
            }
            subObject.put(subKey, (Object)currentValue);
        }
    }, new BasicUpdate("$pop", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            BasicDBList currentList = UpdateEngine.this.expressionParser.typecast(this.command, subObject.get(subKey), BasicDBList.class);
            if (currentList != null && currentList.size() > 0) {
                int direction = UpdateEngine.this.expressionParser.typecast(this.command, object, Number.class).intValue();
                if (direction > 0) {
                    currentList.remove(currentList.size() - 1);
                } else {
                    currentList.remove(0);
                }
            }
        }
    }, new BasicUpdate("$pull", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            BasicDBList currentList = UpdateEngine.this.expressionParser.typecast(this.command + " only works on arrays", subObject.get(subKey), BasicDBList.class);
            if (currentList != null && currentList.size() > 0) {
                BasicDBList newList = new BasicDBList();
                if (object instanceof DBObject) {
                    Filter filter = UpdateEngine.this.expressionParser.buildFilter((DBObject)object);
                    for (Object item : currentList) {
                        if (item instanceof DBObject && filter.apply((DBObject)item)) continue;
                        newList.add(item);
                    }
                } else {
                    for (Object item : currentList) {
                        if (object.equals(item)) continue;
                        newList.add(item);
                    }
                }
                subObject.put(subKey, (Object)newList);
            }
        }
    }, new BasicUpdate("$pullAll", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            BasicDBList currentList = UpdateEngine.this.expressionParser.typecast(this.command + " only works on arrays", subObject.get(subKey), BasicDBList.class);
            if (currentList != null && currentList.size() > 0) {
                HashSet pullSet = new HashSet(UpdateEngine.this.expressionParser.typecast(this.command, object, List.class));
                BasicDBList newList = new BasicDBList();
                for (Object item : currentList) {
                    if (pullSet.contains(item)) continue;
                    newList.add(item);
                }
                subObject.put(subKey, (Object)newList);
            }
        }
    }, new BasicUpdate("$bit", false){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            Number currentNumber = UpdateEngine.this.expressionParser.typecast(this.command + " only works on integers", subObject.get(subKey), Number.class);
            if (currentNumber != null) {
                if (currentNumber instanceof Float || currentNumber instanceof Double) {
                    throw new FongoException(this.command + " only works on integers");
                }
                DBObject bitOps = UpdateEngine.this.expressionParser.typecast(this.command, object, DBObject.class);
                for (String op : bitOps.keySet()) {
                    Number opValue = UpdateEngine.this.expressionParser.typecast(this.command + "." + op, bitOps.get(op), Number.class);
                    if ("and".equals(op)) {
                        if (opValue instanceof Long || currentNumber instanceof Long) {
                            currentNumber = currentNumber.longValue() & opValue.longValue();
                            continue;
                        }
                        currentNumber = currentNumber.intValue() & opValue.intValue();
                        continue;
                    }
                    if ("or".equals(op)) {
                        if (opValue instanceof Long || currentNumber instanceof Long) {
                            currentNumber = currentNumber.longValue() | opValue.longValue();
                            continue;
                        }
                        currentNumber = currentNumber.intValue() | opValue.intValue();
                        continue;
                    }
                    throw new FongoException(this.command + "." + op + " is not valid.");
                }
                subObject.put(subKey, (Object)currentNumber);
            }
        }
    });
    final Map<String, BasicUpdate> commandMap = this.createCommandMap();
    private final BasicUpdate basicUpdateForUpsert = new BasicUpdate("upsert", true){

        @Override
        void mergeAction(String subKey, DBObject subObject, Object object, DBObject objOriginal) {
            subObject.put(subKey, object);
        }
    };

    void keyCheck(String key, Set<String> seenKeys) {
        if (!seenKeys.add(key)) {
            throw new FongoException("attempting more than one atomic update on on " + key);
        }
    }

    Number genericAdd(Number left, Number right) {
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            return left.doubleValue() + right.doubleValue();
        }
        if (left instanceof Integer) {
            return left.intValue() + right.intValue();
        }
        return left.longValue() + (long)right.intValue();
    }

    BasicDBList asDbList(Object ... objects) {
        BasicDBList dbList = new BasicDBList();
        for (Object o : objects) {
            dbList.add(o);
        }
        return dbList;
    }

    private Map<String, BasicUpdate> createCommandMap() {
        HashMap<String, BasicUpdate> map = new HashMap<String, BasicUpdate>();
        for (BasicUpdate item : this.commands) {
            map.put(item.command, item);
        }
        return map;
    }

    public DBObject doUpdate(DBObject obj, DBObject update) {
        return this.doUpdate(obj, update, (DBObject)new BasicDBObject());
    }

    public DBObject doUpdate(DBObject obj, DBObject update, DBObject query) {
        boolean updateDone = false;
        HashSet<String> seenKeys = new HashSet<String>();
        for (String command : update.keySet()) {
            BasicUpdate basicUpdate = this.commandMap.get(command);
            if (basicUpdate != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Doing update for command {}", (Object)command);
                }
                basicUpdate.doUpdate(obj, update, seenKeys, query);
                updateDone = true;
                continue;
            }
            if (!command.startsWith("$")) continue;
            throw new FongoException("unsupported update: " + update);
        }
        if (!updateDone) {
            Iterator iter = obj.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (key == "_id") continue;
                iter.remove();
            }
            obj.putAll((BSONObject)update);
        }
        return obj;
    }

    public void mergeEmbeddedValueFromQuery(BasicDBObject newObject, DBObject q) {
        this.basicUpdateForUpsert.doUpdate((DBObject)newObject, (DBObject)new BasicDBObject(this.basicUpdateForUpsert.command, (Object)q), new HashSet<String>(), q);
    }

    abstract class BasicUpdate {
        private final boolean createMissing;
        final String command;

        public BasicUpdate(String command, boolean createMissing) {
            this.command = command;
            this.createMissing = createMissing;
        }

        abstract void mergeAction(String var1, DBObject var2, Object var3, DBObject var4);

        public DBObject doUpdate(DBObject obj, DBObject update, Set<String> seenKeys, DBObject query) {
            DBObject updateObject = (DBObject)update.get(this.command);
            HashSet keySet = new HashSet(updateObject.keySet());
            LOG.debug("KeySet is of length {}", (Object)keySet.size());
            for (String updateKey : keySet) {
                LOG.debug("\tfound a key {}", (Object)updateKey);
                UpdateEngine.this.keyCheck(updateKey, seenKeys);
                this.doSingleKeyUpdate(updateKey, obj, updateObject.get(updateKey), query);
            }
            return obj;
        }

        void doSingleKeyUpdate(String updateKey, DBObject objOriginal, Object object, DBObject query) {
            List<String> path = Util.split(updateKey);
            String subKey = path.get(0);
            DBObject obj = objOriginal;
            boolean isPositional = updateKey.contains(".$");
            if (isPositional) {
                LOG.debug("got a positional for query {}", (Object)query);
            }
            for (int i = 0; i < path.size() - 1; ++i) {
                Object value;
                if (!obj.containsField(subKey)) {
                    if (this.createMissing && !isPositional) {
                        obj.put(subKey, (Object)new BasicDBObject());
                    } else {
                        return;
                    }
                }
                if ((value = obj.get(subKey)) instanceof List && "$".equals(path.get(i + 1))) {
                    this.handlePositionalUpdate(updateKey, object, (List)value, obj, query, objOriginal);
                } else if (value instanceof DBObject) {
                    obj = (DBObject)value;
                } else if (value instanceof List) {
                    BasicDBList newList = Util.wrap((List)value);
                    obj = newList;
                } else {
                    throw new FongoException("subfield must be object. " + updateKey + " not in " + objOriginal);
                }
                subKey = path.get(i + 1);
            }
            if (!isPositional) {
                LOG.debug("Subobject is {}", (Object)obj);
                this.mergeAction(subKey, obj, object, objOriginal);
                LOG.debug("Full object is {}", (Object)objOriginal);
            }
        }

        public void handlePositionalUpdate(String updateKey, Object object, List valueList, DBObject ownerObj, DBObject query, DBObject objOriginal) {
            int dollarIndex = updateKey.indexOf("$");
            String postPath = dollarIndex == updateKey.length() - 1 ? "" : updateKey.substring(dollarIndex + 2);
            String prePath = updateKey.substring(0, dollarIndex - 1);
            Filter filter = null;
            for (String key : query.keySet()) {
                if (!key.startsWith(prePath)) continue;
                String matchKey = prePath.equals(key) ? key : key.substring(prePath.length() + 1);
                filter = UpdateEngine.this.expressionParser.buildFilter((DBObject)new BasicDBObject(matchKey, query.get(key)));
            }
            if (filter == null) {
                throw new FongoException("positional operator " + updateKey + " must be used on query key " + query);
            }
            for (int i = 0; i < valueList.size(); ++i) {
                DBObject o;
                Object listItem = valueList.get(i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("found a positional list item " + listItem + " " + prePath + " " + postPath);
                }
                if (!postPath.isEmpty()) {
                    if (!(listItem instanceof DBObject)) {
                        throw new FongoException("can not update \"" + postPath + "\" field of non-DBObject object");
                    }
                    if (!filter.apply((DBObject)listItem)) continue;
                    this.doSingleKeyUpdate(postPath, (DBObject)listItem, object, query);
                    break;
                }
                Object object2 = o = listItem instanceof DBObject ? (DBObject)listItem : new BasicDBObject(prePath, listItem);
                if (!filter.apply(o)) continue;
                BasicDBList newList = new BasicDBList();
                newList.addAll((Collection)valueList);
                ownerObj.put(prePath, (Object)newList);
                this.mergeAction(String.valueOf(i), (DBObject)newList, object, objOriginal);
                break;
            }
        }
    }
}

