/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;

public final class SuffixCombFactory
extends AbstCombFactory {
    public SuffixCombFactory() {
        this(SuffixCombFactory.builder());
    }

    public SuffixCombFactory(Clock clock) {
        this(SuffixCombFactory.builder().withClock(clock));
    }

    public SuffixCombFactory(Random random) {
        this(SuffixCombFactory.builder().withRandom(random));
    }

    public SuffixCombFactory(Random random, Clock clock) {
        this(SuffixCombFactory.builder().withRandom(random).withClock(clock));
    }

    public SuffixCombFactory(RandomFunction randomFunction) {
        this(SuffixCombFactory.builder().withRandomFunction(randomFunction));
    }

    public SuffixCombFactory(RandomFunction randomFunction, Clock clock) {
        this(SuffixCombFactory.builder().withRandomFunction(randomFunction).withClock(clock));
    }

    private SuffixCombFactory(Builder builder) {
        super(UuidVersion.VERSION_RANDOM_BASED, builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(10);
        long msb = ByteUtil.toNumber(bytes, 0, 8);
        long lsb = ((long)bytes[8] & 0xFFL) << 8 | (long)bytes[9] & 0xFFL;
        long timestamp = this.clock.millis();
        lsb = lsb << 48 | timestamp & 0xFFFFFFFFFFFFL;
        return this.toUuid(msb, lsb);
    }

    public static class Builder
    extends AbstCombFactory.Builder<SuffixCombFactory> {
        public Builder withClock(Clock clock) {
            return (Builder)super.withClock(clock);
        }

        public Builder withRandom(Random random) {
            return (Builder)super.withRandom(random);
        }

        public Builder withRandomFunction(RandomFunction randomFunction) {
            return (Builder)super.withRandomFunction(randomFunction);
        }

        @Override
        public SuffixCombFactory build() {
            return new SuffixCombFactory(this);
        }
    }
}

