/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.NoArgsFactory;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultRandomFunction;
import java.security.SecureRandom;
import java.util.Random;

public abstract class AbstRandomBasedFactory
extends UuidFactory
implements NoArgsFactory {
    protected final RandomFunction randomFunction;
    protected static final int UUID_BYTES = 16;

    protected AbstRandomBasedFactory(UuidVersion version, RandomFunction randomFunction) {
        super(version);
        this.randomFunction = randomFunction != null ? randomFunction : AbstRandomBasedFactory.newRandomFunction(null);
    }

    protected static RandomFunction newRandomFunction(final Random random) {
        if (random == null) {
            return new DefaultRandomFunction();
        }
        if (random instanceof SecureRandom) {
            Random entropy = random;
            return length -> {
                byte[] bytes = new byte[length];
                entropy.nextBytes(bytes);
                return bytes;
            };
        }
        return new RandomFunction(){
            private final Random entropy;
            {
                this.entropy = random;
            }

            @Override
            public synchronized byte[] apply(int length) {
                byte[] bytes = new byte[length];
                this.entropy.nextBytes(bytes);
                return bytes;
            }
        };
    }
}

