/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid;

import com.github.f4b6a3.uuid.codec.BinaryCodec;
import com.github.f4b6a3.uuid.codec.StringCodec;
import com.github.f4b6a3.uuid.enums.UuidLocalDomain;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.factory.nonstandard.PrefixCombFactory;
import com.github.f4b6a3.uuid.factory.nonstandard.ShortPrefixCombFactory;
import com.github.f4b6a3.uuid.factory.nonstandard.ShortSuffixCombFactory;
import com.github.f4b6a3.uuid.factory.nonstandard.SuffixCombFactory;
import com.github.f4b6a3.uuid.factory.rfc4122.DceSecurityFactory;
import com.github.f4b6a3.uuid.factory.rfc4122.NameBasedMd5Factory;
import com.github.f4b6a3.uuid.factory.rfc4122.NameBasedSha1Factory;
import com.github.f4b6a3.uuid.factory.rfc4122.RandomBasedFactory;
import com.github.f4b6a3.uuid.factory.rfc4122.TimeBasedFactory;
import com.github.f4b6a3.uuid.factory.rfc4122.TimeOrderedEpochFactory;
import com.github.f4b6a3.uuid.factory.rfc4122.TimeOrderedFactory;
import java.time.Instant;
import java.util.UUID;

public final class UuidCreator {
    public static final UuidNamespace NAMESPACE_DNS = UuidNamespace.NAMESPACE_DNS;
    public static final UuidNamespace NAMESPACE_URL = UuidNamespace.NAMESPACE_URL;
    public static final UuidNamespace NAMESPACE_OID = UuidNamespace.NAMESPACE_OID;
    public static final UuidNamespace NAMESPACE_X500 = UuidNamespace.NAMESPACE_X500;
    public static final UuidLocalDomain LOCAL_DOMAIN_PERSON = UuidLocalDomain.LOCAL_DOMAIN_PERSON;
    public static final UuidLocalDomain LOCAL_DOMAIN_GROUP = UuidLocalDomain.LOCAL_DOMAIN_GROUP;
    public static final UuidLocalDomain LOCAL_DOMAIN_ORG = UuidLocalDomain.LOCAL_DOMAIN_ORG;
    private static final UUID UUID_NIL = new UUID(0L, 0L);
    private static final UUID UUID_MAX = new UUID(0x1111111111111111L, 0x1111111111111111L);

    private UuidCreator() {
    }

    public static byte[] toBytes(UUID uuid) {
        return BinaryCodec.INSTANCE.encode(uuid);
    }

    public static UUID fromBytes(byte[] uuid) {
        return BinaryCodec.INSTANCE.decode(uuid);
    }

    public static String toString(UUID uuid) {
        return StringCodec.INSTANCE.encode(uuid);
    }

    public static UUID fromString(String uuid) {
        return StringCodec.INSTANCE.decode(uuid);
    }

    public static UUID getNil() {
        return UUID_NIL;
    }

    public static UUID getMax() {
        return UUID_MAX;
    }

    public static UUID getRandomBased() {
        return RandomBasedHolder.INSTANCE.create();
    }

    public static UUID getTimeBased() {
        return TimeBasedHolder.INSTANCE.create();
    }

    public static UUID getTimeBasedWithMac() {
        return TimeBasedWithMacHolder.INSTANCE.create();
    }

    public static UUID getTimeBasedWithHash() {
        return TimeBasedWithHashHolder.INSTANCE.create();
    }

    public static UUID getTimeBasedWithRandom() {
        return TimeBasedWithRandomHolder.INSTANCE.create();
    }

    public static UUID getTimeBased(Instant instant, Integer clockseq, Long nodeid) {
        TimeBasedFactory.Builder builder = TimeBasedFactory.builder();
        if (instant != null) {
            builder.withInstant(instant);
        }
        if (clockseq != null) {
            builder.withClockSeq(clockseq.intValue());
        }
        if (nodeid != null) {
            builder.withNodeId(nodeid);
        }
        return builder.build().create();
    }

    public static UUID getTimeOrdered() {
        return TimeOrderedHolder.INSTANCE.create();
    }

    public static UUID getTimeOrderedWithMac() {
        return TimeOrderedWithMacHolder.INSTANCE.create();
    }

    public static UUID getTimeOrderedWithHash() {
        return TimeOrderedWithHashHolder.INSTANCE.create();
    }

    public static UUID getTimeOrderedWithRandom() {
        return TimeOrderedWithRandomHolder.INSTANCE.create();
    }

    public static UUID getTimeOrdered(Instant instant, Integer clockseq, Long nodeid) {
        TimeOrderedFactory.Builder builder = TimeOrderedFactory.builder();
        if (instant != null) {
            builder.withInstant(instant);
        }
        if (clockseq != null) {
            builder.withClockSeq(clockseq.intValue());
        }
        if (nodeid != null) {
            builder.withNodeId(nodeid);
        }
        return builder.build().create();
    }

    public static UUID getTimeOrderedEpoch() {
        return TimeOrderedEpochHolder.INSTANCE.create();
    }

    public static UUID getTimeOrderedEpochPlus1() {
        return TimeOrderedEpochPlus1Holder.INSTANCE.create();
    }

    public static UUID getTimeOrderedEpochPlusN() {
        return TimeOrderedEpochPlusNHolder.INSTANCE.create();
    }

    public static UUID getNameBasedMd5(String name) {
        return NameBasedMd5Holder.INSTANCE.create(name);
    }

    public static UUID getNameBasedMd5(byte[] name) {
        return NameBasedMd5Holder.INSTANCE.create(name);
    }

    public static UUID getNameBasedMd5(UUID name) {
        return NameBasedMd5Holder.INSTANCE.create(name);
    }

    public static UUID getNameBasedMd5(UUID namespace, String name) {
        return NameBasedMd5Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(UUID namespace, byte[] name) {
        return NameBasedMd5Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(UUID namespace, UUID name) {
        return NameBasedMd5Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(String namespace, String name) {
        return NameBasedMd5Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(String namespace, byte[] name) {
        return NameBasedMd5Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(String namespace, UUID name) {
        return NameBasedMd5Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(UuidNamespace namespace, String name) {
        return NameBasedMd5Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(UuidNamespace namespace, byte[] name) {
        return NameBasedMd5Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(UuidNamespace namespace, UUID name) {
        return NameBasedMd5Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String name) {
        return NameBasedSha1Holder.INSTANCE.create(name);
    }

    public static UUID getNameBasedSha1(byte[] name) {
        return NameBasedSha1Holder.INSTANCE.create(name);
    }

    public static UUID getNameBasedSha1(UUID name) {
        return NameBasedSha1Holder.INSTANCE.create(name);
    }

    public static UUID getNameBasedSha1(UUID namespace, String name) {
        return NameBasedSha1Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(UUID namespace, byte[] name) {
        return NameBasedSha1Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(UUID namespace, UUID name) {
        return NameBasedSha1Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String namespace, String name) {
        return NameBasedSha1Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String namespace, byte[] name) {
        return NameBasedSha1Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String namespace, UUID name) {
        return NameBasedSha1Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(UuidNamespace namespace, String name) {
        return NameBasedSha1Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(UuidNamespace namespace, byte[] name) {
        return NameBasedSha1Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(UuidNamespace namespace, UUID name) {
        return NameBasedSha1Holder.INSTANCE.create(namespace, name);
    }

    public static UUID getDceSecurity(byte localDomain, int localIdentifier) {
        return DceSecurityHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithMac(byte localDomain, int localIdentifier) {
        return DceSecurityWithMacHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithHash(byte localDomain, int localIdentifier) {
        return DceSecurityWithHashHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithRandom(byte localDomain, int localIdentifier) {
        return DceSecurityWithRandomHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurity(UuidLocalDomain localDomain, int localIdentifier) {
        return DceSecurityHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithMac(UuidLocalDomain localDomain, int localIdentifier) {
        return DceSecurityWithMacHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithHash(UuidLocalDomain localDomain, int localIdentifier) {
        return DceSecurityWithHashHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithRandom(UuidLocalDomain localDomain, int localIdentifier) {
        return DceSecurityWithRandomHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getPrefixComb() {
        return PrefixCombHolder.INSTANCE.create();
    }

    public static UUID getSuffixComb() {
        return SuffixCombHolder.INSTANCE.create();
    }

    public static UUID getShortPrefixComb() {
        return ShortPrefixCombHolder.INSTANCE.create();
    }

    public static UUID getShortSuffixComb() {
        return ShortSuffixCombHolder.INSTANCE.create();
    }

    private static class ShortSuffixCombHolder {
        static final ShortSuffixCombFactory INSTANCE = new ShortSuffixCombFactory();

        private ShortSuffixCombHolder() {
        }
    }

    private static class ShortPrefixCombHolder {
        static final ShortPrefixCombFactory INSTANCE = new ShortPrefixCombFactory();

        private ShortPrefixCombHolder() {
        }
    }

    private static class PrefixCombHolder {
        static final PrefixCombFactory INSTANCE = new PrefixCombFactory();

        private PrefixCombHolder() {
        }
    }

    private static class SuffixCombHolder {
        static final SuffixCombFactory INSTANCE = new SuffixCombFactory();

        private SuffixCombHolder() {
        }
    }

    private static class DceSecurityWithRandomHolder {
        static final DceSecurityFactory INSTANCE = (DceSecurityFactory)new DceSecurityFactory.Builder().withRandomNodeId().build();

        private DceSecurityWithRandomHolder() {
        }
    }

    private static class DceSecurityWithHashHolder {
        static final DceSecurityFactory INSTANCE = (DceSecurityFactory)new DceSecurityFactory.Builder().withHashNodeId().build();

        private DceSecurityWithHashHolder() {
        }
    }

    private static class DceSecurityWithMacHolder {
        static final DceSecurityFactory INSTANCE = (DceSecurityFactory)new DceSecurityFactory.Builder().withMacNodeId().build();

        private DceSecurityWithMacHolder() {
        }
    }

    private static class DceSecurityHolder {
        static final DceSecurityFactory INSTANCE = new DceSecurityFactory();

        private DceSecurityHolder() {
        }
    }

    private static class NameBasedSha1Holder {
        static final NameBasedSha1Factory INSTANCE = new NameBasedSha1Factory();

        private NameBasedSha1Holder() {
        }
    }

    private static class NameBasedMd5Holder {
        static final NameBasedMd5Factory INSTANCE = new NameBasedMd5Factory();

        private NameBasedMd5Holder() {
        }
    }

    private static class TimeOrderedEpochPlusNHolder {
        static final TimeOrderedEpochFactory INSTANCE = TimeOrderedEpochFactory.builder().withIncrementPlusN().build();

        private TimeOrderedEpochPlusNHolder() {
        }
    }

    private static class TimeOrderedEpochPlus1Holder {
        static final TimeOrderedEpochFactory INSTANCE = TimeOrderedEpochFactory.builder().withIncrementPlus1().build();

        private TimeOrderedEpochPlus1Holder() {
        }
    }

    private static class TimeOrderedEpochHolder {
        static final TimeOrderedEpochFactory INSTANCE = new TimeOrderedEpochFactory();

        private TimeOrderedEpochHolder() {
        }
    }

    private static class TimeOrderedWithRandomHolder {
        static final TimeOrderedFactory INSTANCE = (TimeOrderedFactory)new TimeOrderedFactory.Builder().withRandomNodeId().build();

        private TimeOrderedWithRandomHolder() {
        }
    }

    private static class TimeOrderedWithHashHolder {
        static final TimeOrderedFactory INSTANCE = (TimeOrderedFactory)new TimeOrderedFactory.Builder().withHashNodeId().build();

        private TimeOrderedWithHashHolder() {
        }
    }

    private static class TimeOrderedWithMacHolder {
        static final TimeOrderedFactory INSTANCE = (TimeOrderedFactory)new TimeOrderedFactory.Builder().withMacNodeId().build();

        private TimeOrderedWithMacHolder() {
        }
    }

    private static class TimeOrderedHolder {
        static final TimeOrderedFactory INSTANCE = new TimeOrderedFactory();

        private TimeOrderedHolder() {
        }
    }

    private static class TimeBasedWithRandomHolder {
        static final TimeBasedFactory INSTANCE = (TimeBasedFactory)new TimeBasedFactory.Builder().withRandomNodeId().build();

        private TimeBasedWithRandomHolder() {
        }
    }

    private static class TimeBasedWithHashHolder {
        static final TimeBasedFactory INSTANCE = (TimeBasedFactory)new TimeBasedFactory.Builder().withHashNodeId().build();

        private TimeBasedWithHashHolder() {
        }
    }

    private static class TimeBasedWithMacHolder {
        static final TimeBasedFactory INSTANCE = (TimeBasedFactory)new TimeBasedFactory.Builder().withMacNodeId().build();

        private TimeBasedWithMacHolder() {
        }
    }

    private static class TimeBasedHolder {
        static final TimeBasedFactory INSTANCE = new TimeBasedFactory();

        private TimeBasedHolder() {
        }
    }

    private static class RandomBasedHolder {
        static final RandomBasedFactory INSTANCE = new RandomBasedFactory();

        private RandomBasedHolder() {
        }
    }
}

