/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultRandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;

public final class ShortSuffixCombFactory
extends AbstRandomBasedFactory {
    private final Clock clock;
    private static final int ONE_MINUTE = 60000;

    public ShortSuffixCombFactory() {
        this(new DefaultRandomFunction());
    }

    public ShortSuffixCombFactory(Clock clock) {
        this(new DefaultRandomFunction(), clock);
    }

    public ShortSuffixCombFactory(Random random) {
        this(ShortSuffixCombFactory.getRandomFunction(random));
    }

    public ShortSuffixCombFactory(Random random, Clock clock) {
        this(ShortSuffixCombFactory.getRandomFunction(random), clock);
    }

    public ShortSuffixCombFactory(RandomFunction randomFunction) {
        this(randomFunction, Clock.systemUTC());
    }

    public ShortSuffixCombFactory(RandomFunction randomFunction, Clock clock) {
        super(UuidVersion.VERSION_RANDOM_BASED, randomFunction);
        this.clock = clock;
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(14);
        long msb = ByteUtil.toNumber(bytes, 0, 8);
        long lsb = ByteUtil.toNumber(bytes, 8, 14);
        long timestamp = this.clock.millis() / 60000L;
        lsb = (lsb & 0xFFFF00000000L) << 16 | lsb & 0xFFFFFFFFL | (timestamp & 0xFFFFL) << 32;
        return this.getUuid(msb, lsb);
    }
}

