/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultRandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;

public final class ShortPrefixCombFactory
extends AbstRandomBasedFactory {
    private final Clock clock;
    private static final int ONE_MINUTE = 60000;

    public ShortPrefixCombFactory() {
        this(new DefaultRandomFunction());
    }

    public ShortPrefixCombFactory(Clock clock) {
        this(new DefaultRandomFunction(), clock);
    }

    public ShortPrefixCombFactory(Random random) {
        this(ShortPrefixCombFactory.getRandomFunction(random));
    }

    public ShortPrefixCombFactory(Random random, Clock clock) {
        this(ShortPrefixCombFactory.getRandomFunction(random), clock);
    }

    public ShortPrefixCombFactory(RandomFunction randomFunction) {
        this(randomFunction, Clock.systemUTC());
    }

    public ShortPrefixCombFactory(RandomFunction randomFunction, Clock clock) {
        super(UuidVersion.VERSION_RANDOM_BASED, randomFunction);
        this.clock = clock;
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(14);
        long msb = ByteUtil.toNumber(bytes, 8, 14);
        long lsb = ByteUtil.toNumber(bytes, 0, 8);
        long timestamp = this.clock.millis() / 60000L;
        return this.getUuid(msb |= (timestamp & 0xFFFFL) << 48, lsb);
    }
}

