/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base;

import com.github.f4b6a3.uuid.exception.UuidCodecException;
import com.github.f4b6a3.uuid.util.internal.immutable.CharArray;
import com.github.f4b6a3.uuid.util.internal.immutable.LongArray;

public final class BaseN {
    public static final BaseN BASE_16 = new BaseN("0-9a-f");
    public static final BaseN BASE_32 = new BaseN("a-z2-7");
    public static final BaseN BASE_32_HEX = new BaseN("0-9a-v");
    public static final BaseN BASE_32_CROCKFORD = new BaseN("0123456789abcdefghjkmnpqrstvwxyz");
    public static final BaseN BASE_36 = new BaseN("0-9a-z");
    public static final BaseN BASE_58 = new BaseN("0-9A-Za-v");
    public static final BaseN BASE_58_BITCOIN = new BaseN("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz");
    public static final BaseN BASE_58_FLICKR = new BaseN("123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ");
    public static final BaseN BASE_62 = new BaseN("0-9A-Za-z");
    public static final BaseN BASE_64 = new BaseN("A-Za-z0-9+/");
    public static final BaseN BASE_64_URL = new BaseN("A-Za-z0-9-_");
    private int radix;
    private int length;
    private boolean sensitive;
    private char padding;
    private final CharArray alphabet;
    private final CharArray validchars;
    private final LongArray map;
    protected static final int RADIX_MIN = 2;
    protected static final int RADIX_MAX = 64;
    private static final int BIT_LENGTH = 128;

    public BaseN(int radix) {
        this(BaseN.alphabet(radix));
    }

    public BaseN(String alphabet) {
        String charset = BaseN.expand(alphabet);
        this.alphabet = CharArray.from(charset.toCharArray());
        this.radix = charset.length();
        if (this.radix < 2 || this.radix > 64) {
            throw new UuidCodecException("Unsupported radix: " + this.radix);
        }
        this.length = (int)Math.ceil(128.0 / (Math.log(this.radix) / Math.log(2.0)));
        this.sensitive = BaseN.sensitive(charset);
        this.padding = charset.charAt(0);
        this.validchars = BaseN.validchars(charset, this.sensitive);
        this.map = BaseN.map(charset, this.sensitive);
    }

    public int getRadix() {
        return this.radix;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public char getPadding() {
        return this.padding;
    }

    public CharArray getAlphabet() {
        return this.alphabet;
    }

    public LongArray getMap() {
        return this.map;
    }

    public void validate(char[] chars) {
        if (chars == null || chars.length != this.length) {
            throw new UuidCodecException("Invalid string: \"" + (chars == null ? null : new String(chars)) + "\"");
        }
        for (int i = 0; i < chars.length; ++i) {
            boolean found = false;
            for (int j = 0; j < this.validchars.length(); ++j) {
                if (chars[i] != this.validchars.get(j)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new UuidCodecException("Invalid string: \"" + new String(chars) + "\"");
        }
    }

    private static boolean sensitive(String charset) {
        String lowercase = charset.toLowerCase();
        String uppercase = charset.toUpperCase();
        return !charset.equals(lowercase) && !charset.equals(uppercase);
    }

    private static CharArray validchars(String alphabet, boolean sensitive) {
        if (sensitive) {
            return CharArray.from(alphabet.toCharArray());
        }
        String lowercase = alphabet.toLowerCase();
        String uppercase = alphabet.toUpperCase();
        StringBuilder merged = new StringBuilder();
        for (int i = 0; i < alphabet.length(); ++i) {
            char u;
            char l = lowercase.charAt(i);
            if (l == (u = uppercase.charAt(i))) {
                merged.append(l);
                continue;
            }
            merged.append(l);
            merged.append(u);
        }
        return CharArray.from(merged.toString().toCharArray());
    }

    private static String alphabet(int radix) {
        String string = radix > 36 ? BaseN.expand("0-9A-Za-z-_") : BaseN.expand("0-9a-z");
        return string.substring(0, radix);
    }

    private static LongArray map(String alphabet, boolean sensitive) {
        long[] mapping = new long[128];
        for (int i = 0; i < mapping.length; ++i) {
            mapping[i] = -1L;
        }
        String lowercase = alphabet.toLowerCase();
        String uppercase = alphabet.toUpperCase();
        for (int i = 0; i < alphabet.length(); ++i) {
            if (sensitive) {
                mapping[alphabet.charAt((int)i)] = i;
                continue;
            }
            mapping[lowercase.charAt((int)i)] = i;
            mapping[uppercase.charAt((int)i)] = i;
        }
        return LongArray.from(mapping);
    }

    protected static String expand(String string) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 1; i <= string.length(); ++i) {
            char a = string.charAt(i - 1);
            if (i < string.length() - 1 && string.charAt(i) == '-') {
                char b = string.charAt(i + 1);
                char[] expanded = BaseN.expand(a, b);
                if (expanded.length != 0) {
                    i += 2;
                    buffer.append(expanded);
                    continue;
                }
                buffer.append(a);
                continue;
            }
            buffer.append(a);
        }
        return buffer.toString();
    }

    private static char[] expand(char a, char b) {
        char[] expanded = BaseN.expand(a, b, '0', '9');
        if (expanded.length == 0) {
            expanded = BaseN.expand(a, b, 'a', 'z');
        }
        if (expanded.length == 0) {
            expanded = BaseN.expand(a, b, 'A', 'Z');
        }
        return expanded;
    }

    private static char[] expand(char a, char b, char min, char max) {
        if (a > b || a < min || a > max || b < min || b > max) {
            return new char[0];
        }
        char[] buffer = new char[b - a + 1];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (char)(a + i);
        }
        return buffer;
    }
}

