/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.uuid;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.util.UuidUtil;
import java.util.UUID;

public class DotNetGuid1Codec
implements UuidCodec<UUID> {
    @Override
    public UUID encode(UUID uuid) {
        if (!UuidUtil.isTimeBased(uuid)) {
            throw new IllegalArgumentException(String.format("Not a time-based UUID: %s.", uuid.toString()));
        }
        return DotNetGuid1Codec.toAndFromDotNetGuid(uuid);
    }

    @Override
    public UUID decode(UUID uuid) {
        UUID uuidv1 = DotNetGuid1Codec.toAndFromDotNetGuid(uuid);
        if (!UuidUtil.isTimeBased(uuidv1)) {
            throw new IllegalArgumentException(String.format("Not a time-based UUID: %s.", uuidv1.toString()));
        }
        return uuidv1;
    }

    protected static UUID toAndFromDotNetGuid(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        long newMsb = 0L;
        newMsb |= (msb & 0xFF00000000000000L) >>> 24;
        newMsb |= (msb & 0xFF000000000000L) >>> 8;
        newMsb |= (msb & 0xFF0000000000L) << 8;
        newMsb |= (msb & 0xFF00000000L) << 24;
        newMsb |= (msb & 0xFF000000L) >>> 8;
        newMsb |= (msb & 0xFF0000L) << 8;
        newMsb |= (msb & 0xFF00L) >>> 8;
        return new UUID(newMsb |= (msb & 0xFFL) << 8, lsb);
    }
}

