/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

public final class UuidSettings {
    protected static final String PROPERTY_PREFIX = "uuidcreator";
    @Deprecated
    protected static final String PROPERTY_NODEID = "nodeid";
    protected static final String PROPERTY_NODE = "node";

    protected UuidSettings() {
    }

    public static long getNodeIdentifier() {
        String value = UuidSettings.getProperty(PROPERTY_NODE);
        if (value == null || value.isEmpty()) {
            return -1L;
        }
        try {
            return Long.decode(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static void setNodeIdentifier(long nodeid) {
        String value = Long.toString(nodeid);
        UuidSettings.setProperty(PROPERTY_NODE, value);
    }

    @Deprecated
    protected static long getNodeIdentifierDeprecated() {
        String value = UuidSettings.getProperty(PROPERTY_NODEID);
        if (value == null || !value.matches("^(0x|0X)?[0-9A-Fa-f]+$")) {
            return -1L;
        }
        if (!value.toLowerCase().startsWith("0x")) {
            value = "0x" + value;
        }
        try {
            return Long.decode(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Deprecated
    protected static void setNodeIdentifierDeprecated(long nodeid) {
        String value = Long.toHexString(nodeid);
        UuidSettings.setProperty(PROPERTY_NODEID, value);
    }

    protected static String getProperty(String name) {
        String fullName = UuidSettings.getPropertyName(name);
        String value = System.getProperty(fullName);
        if (!UuidSettings.isEmpty(value)) {
            return value;
        }
        fullName = UuidSettings.getEnvinronmentName(name);
        value = System.getenv(fullName);
        if (!UuidSettings.isEmpty(value)) {
            return value;
        }
        return null;
    }

    protected static void setProperty(String key, String value) {
        System.setProperty(UuidSettings.getPropertyName(key), value);
    }

    protected static void clearProperty(String key) {
        System.clearProperty(UuidSettings.getPropertyName(key));
    }

    protected static String getPropertyName(String key) {
        return String.join((CharSequence)".", PROPERTY_PREFIX, key);
    }

    protected static String getEnvinronmentName(String key) {
        return String.join((CharSequence)"_", PROPERTY_PREFIX, key).toUpperCase().replace(".", "_");
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

