/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import java.time.Instant;

public final class UuidTimeUtil {
    public static final long GREGORIAN_MILLISECONDS = UuidTimeUtil.getGregorianMilliseconds();
    public static final long MILLISECONDS_PER_SECOND = 1000L;
    public static final long TIMESTAMP_RESOLUTION = 10000L;

    private UuidTimeUtil() {
    }

    public static long getCurrentTimestamp() {
        return UuidTimeUtil.toTimestamp(System.currentTimeMillis());
    }

    public static long toTimestamp(long unixMilliseconds) {
        return (unixMilliseconds - GREGORIAN_MILLISECONDS) * 10000L;
    }

    public static long toUnixMilliseconds(long timestamp) {
        return timestamp / 10000L + GREGORIAN_MILLISECONDS;
    }

    public static long toTimestamp(Instant instant) {
        long a = (instant.toEpochMilli() - GREGORIAN_MILLISECONDS) * 10000L;
        long b = instant.getNano() / 100 % 10000;
        return a + b;
    }

    public static Instant toInstant(long timestamp) {
        long millis = timestamp / 10000L + GREGORIAN_MILLISECONDS;
        long nanos = timestamp % 10000L * 100L;
        return Instant.ofEpochMilli(millis).plusNanos(nanos);
    }

    private static long getGregorianMilliseconds() {
        return Instant.parse("1582-10-15T00:00:00.000Z").getEpochSecond() * 1000L;
    }
}

