/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator.nonstandard;

import com.github.f4b6a3.uuid.creator.AbstractRandomBasedUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.util.ByteUtil;
import java.util.UUID;

public class ShortSuffixCombCreator
extends AbstractRandomBasedUuidCreator {
    protected static final int ONE_MINUTE = 60000;

    public ShortSuffixCombCreator() {
        super(UuidVersion.VERSION_RANDOM_BASED);
    }

    @Override
    public synchronized UUID create() {
        short timestamp = (short)(System.currentTimeMillis() / 60000L);
        byte[] bytes = new byte[14];
        this.randomStrategy.nextBytes(bytes);
        long msb = ByteUtil.toNumber(bytes, 0, 8);
        long lsb = ByteUtil.toNumber(bytes, 8, 14);
        lsb = (lsb & 0xFFFF00000000L) << 16 | lsb & 0xFFFFFFFFL | ((long)timestamp & 0xFFFFL) << 32;
        return new UUID(this.applyVersionBits(msb), this.applyVariantBits(lsb));
    }
}

