/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

public class SettingsUtil {
    protected static final String PROPERTY_PREFIX = "uuidcreator";
    public static final String PROPERTY_NODEID = "nodeid";

    protected SettingsUtil() {
    }

    public static long getNodeIdentifier() {
        String value = SettingsUtil.getProperty(PROPERTY_NODEID);
        if (value == null || !value.matches("^(0x|0X)?[0-9A-Fa-f]+$")) {
            return 0L;
        }
        if (!value.toLowerCase().startsWith("0x")) {
            value = "0x" + value;
        }
        try {
            return Long.decode(value) & 0xFFFFFFFFFFFFL;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static void setNodeIdentifier(long nodeid) {
        String value = Long.toHexString(nodeid & 0xFFFFFFFFFFFFL);
        SettingsUtil.setProperty(PROPERTY_NODEID, value);
    }

    protected static String getProperty(String name) {
        String fullName = SettingsUtil.getPropertyName(name);
        String value = System.getProperty(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        fullName = SettingsUtil.getEnvinronmentName(name);
        value = System.getenv(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        return null;
    }

    protected static void setProperty(String key, String value) {
        System.setProperty(SettingsUtil.getPropertyName(key), value);
    }

    protected static void clearProperty(String key) {
        System.clearProperty(SettingsUtil.getPropertyName(key));
    }

    protected static String getPropertyName(String key) {
        return String.join((CharSequence)".", PROPERTY_PREFIX, key);
    }

    protected static String getEnvinronmentName(String key) {
        return String.join((CharSequence)"_", PROPERTY_PREFIX, key).toUpperCase().replace(".", "_");
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

