/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.commons.util.ByteUtil;

public class SettingsUtil {
    protected static final String PROPERTY_PREFIX = "uuidcreator";
    public static final String PROPERTY_NODEID = "nodeid";

    private SettingsUtil() {
    }

    public static long getNodeIdentifier() {
        String value = SettingsUtil.getProperty(PROPERTY_NODEID);
        if (value == null) {
            return 0L;
        }
        if (value.toLowerCase().startsWith("0x")) {
            value = value.substring(2);
        }
        return ByteUtil.toNumber((String)value) & 0xFFFFFFFFFFFFL;
    }

    public static void setNodeIdentifier(long nodeid) {
        String value = ByteUtil.toHexadecimal((long)(nodeid & 0xFFFFFFFFFFFFL));
        SettingsUtil.setProperty(PROPERTY_NODEID, value);
    }

    private static String getProperty(String name) {
        String fullName = SettingsUtil.getPropertyName(name);
        String value = System.getProperty(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        fullName = SettingsUtil.getEnvinronmentName(name);
        value = System.getenv(fullName);
        if (!SettingsUtil.isEmpty(value)) {
            return value;
        }
        return null;
    }

    private static void setProperty(String key, String value) {
        System.setProperty(SettingsUtil.getPropertyName(key), value);
    }

    private static String getPropertyName(String key) {
        return String.join((CharSequence)".", PROPERTY_PREFIX, key);
    }

    private static String getEnvinronmentName(String key) {
        return String.join((CharSequence)"_", PROPERTY_PREFIX, key).toUpperCase().replace(".", "_");
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

