/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.clockseq;

import com.github.f4b6a3.uuid.clockseq.ClockSequenceController;
import com.github.f4b6a3.uuid.clockseq.ClockSequenceStrategy;
import com.github.f4b6a3.uuid.sequence.AbstractSequence;
import com.github.f4b6a3.uuid.state.AbstractUuidState;
import com.github.f4b6a3.uuid.state.FileUuidState;
import com.github.f4b6a3.uuid.util.RandomUtil;
import com.github.f4b6a3.uuid.util.SettingsUtil;

public class DefaultClockSequenceStrategy
extends AbstractSequence
implements ClockSequenceStrategy {
    private long previousTimestamp = 0L;
    private long previousNodeIdentifier = 0L;
    protected AbstractUuidState state;
    protected static final int SEQUENCE_MIN = 0;
    protected static final int SEQUENCE_MAX = 16383;
    public static final ClockSequenceController CONTROLLER = new ClockSequenceController();

    public DefaultClockSequenceStrategy(long timestamp, long nodeIdentifier, AbstractUuidState state) {
        super(0L, 16383L);
        this.value = -1L;
        this.previousTimestamp = timestamp;
        this.previousNodeIdentifier = nodeIdentifier;
        if (SettingsUtil.isStateEnabled()) {
            this.addShutdownHook();
            this.state = state;
            if (this.state == null) {
                this.state = new FileUuidState();
            }
            if (!this.state.isValid()) {
                this.reset();
                return;
            }
            long lastTimestamp = this.state.getTimestamp();
            long lastNodeIdentifier = this.state.getNodeIdentifier();
            long lastClockSequence = this.state.getClockSequence();
            this.set(lastClockSequence);
            if (this.previousTimestamp <= lastTimestamp || this.previousNodeIdentifier != lastNodeIdentifier) {
                this.next();
            }
        } else {
            this.reset();
        }
    }

    public DefaultClockSequenceStrategy(long timestamp, long nodeIdentifier) {
        this(timestamp, nodeIdentifier, null);
    }

    public DefaultClockSequenceStrategy() {
        this(0L, 0L, null);
    }

    @Override
    public long getClockSequence(long timestamp) {
        if (timestamp > this.previousTimestamp) {
            this.previousTimestamp = timestamp;
            return this.current();
        }
        this.previousTimestamp = timestamp;
        return this.next();
    }

    @Override
    public long next() {
        int give = (int)this.current();
        int take = (int)super.next();
        this.value = CONTROLLER.borrow(give, take);
        return this.value;
    }

    @Override
    public void reset() {
        int give = (int)this.current();
        int take = RandomUtil.getInstance().nextInt(16384);
        this.value = CONTROLLER.borrow(give, take);
    }

    protected void storeState() {
        if (SettingsUtil.isStateEnabled()) {
            this.state.setNodeIdentifier(this.previousNodeIdentifier);
            this.state.setTimestamp(this.previousTimestamp);
            this.state.setClockSequence(this.value);
            this.state.store();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new DefaultClockSequenceShutdownHook(this));
    }

    protected static class DefaultClockSequenceShutdownHook
    extends Thread {
        private DefaultClockSequenceStrategy strategy;

        public DefaultClockSequenceShutdownHook(DefaultClockSequenceStrategy strategy) {
            this.strategy = strategy;
        }

        @Override
        public void run() {
            this.strategy.storeState();
        }
    }
}

