/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.clockseq;

public class ClockSequenceController {
    protected byte[] pool = new byte[2048];
    protected static final int POOL_MAX = 16384;

    public synchronized int borrow(int give, int take) {
        for (int i = 0; i < 16384; ++i) {
            if (this.setBit(take)) {
                this.clearBit(give);
                return take;
            }
            ++take;
            take %= 16384;
        }
        this.clearPool();
        this.setBit(take);
        return take;
    }

    private synchronized boolean setBit(int value) {
        boolean clear;
        if (value < 0) {
            return false;
        }
        int byteIndex = value / 8;
        int bitIndex = value % 8;
        int mask = 1 << bitIndex;
        boolean bl = clear = (this.pool[byteIndex] & mask) == 0;
        if (clear) {
            this.pool[byteIndex] = (byte)(this.pool[byteIndex] | mask);
            return true;
        }
        return false;
    }

    private synchronized void clearBit(int value) {
        if (value < 0) {
            return;
        }
        int byteIndex = value / 8;
        int bitIndex = value % 8;
        int mask = ~(1 << bitIndex);
        this.pool[byteIndex] = (byte)(this.pool[byteIndex] & mask);
    }

    public boolean isUsed(int value) {
        int byteIndex = value / 8;
        int bitIndex = value % 8;
        int mask = 1 << bitIndex;
        boolean clear = (this.pool[byteIndex] & mask) == 0;
        return !clear;
    }

    public boolean isFree(int value) {
        return !this.isUsed(value);
    }

    public int countUsed() {
        int counter = 0;
        for (int i = 0; i < 16384; ++i) {
            if (!this.isUsed(i)) continue;
            ++counter;
        }
        return counter;
    }

    public int countFree() {
        return 16384 - this.countUsed();
    }

    public synchronized void clearPool() {
        for (int i = 0; i < this.pool.length; ++i) {
            this.pool[i] = 0;
        }
    }
}

