/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid;

import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.factory.CombGuidCreator;
import com.github.f4b6a3.uuid.factory.DceSecurityUuidCreator;
import com.github.f4b6a3.uuid.factory.LexicalOrderGuidCreator;
import com.github.f4b6a3.uuid.factory.NameBasedMd5UuidCreator;
import com.github.f4b6a3.uuid.factory.NameBasedSha1UuidCreator;
import com.github.f4b6a3.uuid.factory.RandomUuidCreator;
import com.github.f4b6a3.uuid.factory.SequentialUuidCreator;
import com.github.f4b6a3.uuid.factory.TimeBasedUuidCreator;
import com.github.f4b6a3.uuid.factory.abst.AbstractTimeBasedUuidCreator;
import java.util.UUID;

public class UuidCreator {
    private UuidCreator() {
    }

    public static UUID getNil() {
        return new UUID(0L, 0L);
    }

    public static UUID getRandom() {
        return RandomCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getFastRandom() {
        return FastRandomCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getSequential() {
        return SequentialCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getSequentialWithMac() {
        return SequentialWithMacCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getSequentialWithFingerprint() {
        return SequentialWithFingerprintCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getTimeBased() {
        return TimeBasedCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getTimeBasedWithMac() {
        return TimeBasedWithMacCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getTimeBasedWithFingerprint() {
        return TimeBasedWithFingerprintCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getDceSecurity(byte localDomain, int localIdentifier) {
        return DceSecurityCreatorLazyHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithMac(byte localDomain, int localIdentifier) {
        return DceSecurityWithMacCreatorLazyHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithFingerprint(byte localDomain, int localIdentifier) {
        return DceSecurityWithFingerprintCreatorLazyHolder.INSTANCE.create(localDomain, localIdentifier);
    }

    public static UUID getNameBasedMd5(String name) {
        return NameBasedMd5CreatorLazyHolder.INSTANCE.create(name);
    }

    public static UUID getNameBasedMd5(UUID namespace, String name) {
        return NameBasedMd5CreatorLazyHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedMd5(UuidNamespace namespace, String name) {
        return NameBasedMd5CreatorLazyHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String name) {
        return NameBasedSha1CreatorLazyHolder.INSTANCE.create(name);
    }

    public static UUID getNameBasedSha1(UUID namespace, String name) {
        return NameBasedSha1CreatorLazyHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getNameBasedSha1(UuidNamespace namespace, String name) {
        return NameBasedSha1CreatorLazyHolder.INSTANCE.create(namespace, name);
    }

    public static UUID getCombGuid() {
        return CombCreatorLazyHolder.INSTANCE.create();
    }

    public static UUID getLexicalOrderGuid() {
        return LexicalOrderCreatorLazyHolder.INSTANCE.create();
    }

    public static SequentialUuidCreator getSequentialCreator() {
        return new SequentialUuidCreator();
    }

    public static TimeBasedUuidCreator getTimeBasedCreator() {
        return new TimeBasedUuidCreator();
    }

    public static DceSecurityUuidCreator getDceSecurityCreator() {
        return new DceSecurityUuidCreator();
    }

    public static NameBasedMd5UuidCreator getNameBasedMd5Creator() {
        return new NameBasedMd5UuidCreator();
    }

    public static RandomUuidCreator getRandomCreator() {
        return new RandomUuidCreator();
    }

    public static RandomUuidCreator getFastRandomCreator() {
        return new RandomUuidCreator().withFastRandomGenerator();
    }

    public static NameBasedSha1UuidCreator getNameBasedSha1Creator() {
        return new NameBasedSha1UuidCreator();
    }

    public static CombGuidCreator getCombCreator() {
        return new CombGuidCreator();
    }

    public static LexicalOrderGuidCreator getLexicalOrderCreator() {
        return new LexicalOrderGuidCreator();
    }

    private static class LexicalOrderCreatorLazyHolder {
        static final LexicalOrderGuidCreator INSTANCE = UuidCreator.getLexicalOrderCreator().withoutOverflowException();

        private LexicalOrderCreatorLazyHolder() {
        }
    }

    private static class CombCreatorLazyHolder {
        static final CombGuidCreator INSTANCE = (CombGuidCreator)UuidCreator.getCombCreator().withoutOverflowException();

        private CombCreatorLazyHolder() {
        }
    }

    private static class DceSecurityWithFingerprintCreatorLazyHolder {
        static final DceSecurityUuidCreator INSTANCE = (DceSecurityUuidCreator)UuidCreator.getDceSecurityCreator().withFingerprintNodeIdentifier();

        private DceSecurityWithFingerprintCreatorLazyHolder() {
        }
    }

    private static class DceSecurityWithMacCreatorLazyHolder {
        static final DceSecurityUuidCreator INSTANCE = (DceSecurityUuidCreator)UuidCreator.getDceSecurityCreator().withHardwareAddressNodeIdentifier();

        private DceSecurityWithMacCreatorLazyHolder() {
        }
    }

    private static class DceSecurityCreatorLazyHolder {
        static final DceSecurityUuidCreator INSTANCE = UuidCreator.getDceSecurityCreator();

        private DceSecurityCreatorLazyHolder() {
        }
    }

    private static class NameBasedSha1CreatorLazyHolder {
        static final NameBasedSha1UuidCreator INSTANCE = UuidCreator.getNameBasedSha1Creator();

        private NameBasedSha1CreatorLazyHolder() {
        }
    }

    private static class NameBasedMd5CreatorLazyHolder {
        static final NameBasedMd5UuidCreator INSTANCE = UuidCreator.getNameBasedMd5Creator();

        private NameBasedMd5CreatorLazyHolder() {
        }
    }

    private static class TimeBasedWithFingerprintCreatorLazyHolder {
        static final TimeBasedUuidCreator INSTANCE = (TimeBasedUuidCreator)((AbstractTimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withoutOverrunException()).withFingerprintNodeIdentifier();

        private TimeBasedWithFingerprintCreatorLazyHolder() {
        }
    }

    private static class TimeBasedWithMacCreatorLazyHolder {
        static final TimeBasedUuidCreator INSTANCE = (TimeBasedUuidCreator)((AbstractTimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withoutOverrunException()).withHardwareAddressNodeIdentifier();

        private TimeBasedWithMacCreatorLazyHolder() {
        }
    }

    private static class TimeBasedCreatorLazyHolder {
        static final TimeBasedUuidCreator INSTANCE = (TimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withoutOverrunException();

        private TimeBasedCreatorLazyHolder() {
        }
    }

    private static class SequentialWithFingerprintCreatorLazyHolder {
        static final SequentialUuidCreator INSTANCE = (SequentialUuidCreator)((AbstractTimeBasedUuidCreator)UuidCreator.getSequentialCreator().withoutOverrunException()).withFingerprintNodeIdentifier();

        private SequentialWithFingerprintCreatorLazyHolder() {
        }
    }

    private static class SequentialWithMacCreatorLazyHolder {
        static final SequentialUuidCreator INSTANCE = (SequentialUuidCreator)((AbstractTimeBasedUuidCreator)UuidCreator.getSequentialCreator().withoutOverrunException()).withHardwareAddressNodeIdentifier();

        private SequentialWithMacCreatorLazyHolder() {
        }
    }

    private static class SequentialCreatorLazyHolder {
        static final SequentialUuidCreator INSTANCE = (SequentialUuidCreator)UuidCreator.getSequentialCreator().withoutOverrunException();

        private SequentialCreatorLazyHolder() {
        }
    }

    private static class FastRandomCreatorLazyHolder {
        static final RandomUuidCreator INSTANCE = UuidCreator.getFastRandomCreator();

        private FastRandomCreatorLazyHolder() {
        }
    }

    private static class RandomCreatorLazyHolder {
        static final RandomUuidCreator INSTANCE = UuidCreator.getRandomCreator();

        private RandomCreatorLazyHolder() {
        }
    }
}

