/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

public class ByteUtil {
    private ByteUtil() {
    }

    public static long toNumber(String hexadecimal) {
        return ByteUtil.toNumber(ByteUtil.toBytes(hexadecimal));
    }

    public static long toNumber(byte[] bytes) {
        long result = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            result = result << 8 | (long)(bytes[i] & 0xFF);
        }
        return result;
    }

    public static byte[] toBytes(long number) {
        return ByteUtil.toBytes(number, 8);
    }

    public static byte[] toBytes(long number, int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(number >>> 8 * (bytes.length - 1 - i));
        }
        return bytes;
    }

    public static byte[] toBytes(String hexadecimal) {
        int len = hexadecimal.length();
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)(ByteUtil.fromHexChar(hexadecimal.charAt(i)) << 4 | ByteUtil.fromHexChar(hexadecimal.charAt(i + 1)));
        }
        return bytes;
    }

    public static String toHexadecimal(byte[] bytes) {
        char[] hexadecimal = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexadecimal[i * 2] = ByteUtil.toHexChar(v >>> 4);
            hexadecimal[i * 2 + 1] = ByteUtil.toHexChar(v & 0xF);
        }
        return new String(hexadecimal);
    }

    public static String toHexadecimal(long number) {
        return ByteUtil.toHexadecimal(ByteUtil.toBytes(number));
    }

    public static int fromHexChar(char chr) {
        if (chr >= 'a' && chr <= 'f') {
            return chr - 87;
        }
        if (chr >= 'A' && chr <= 'F') {
            return chr - 55;
        }
        if (chr >= '0' && chr <= '9') {
            return chr - 48;
        }
        return 0;
    }

    public static char toHexChar(int number) {
        if (number >= 10 && number <= 15) {
            return (char)(87 + number);
        }
        if (number >= 0 && number <= 9) {
            return (char)(48 + number);
        }
        return '\u0000';
    }

    public static byte[] array(int length, byte value) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static byte[] copy(byte[] bytes) {
        return ByteUtil.copy(bytes, 0, bytes.length);
    }

    public static byte[] copy(byte[] bytes, int start, int end) {
        byte[] result = new byte[end - start];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bytes[start + i];
        }
        return result;
    }

    public static byte[] concat(byte[] bytes1, byte[] bytes2) {
        int length = bytes1.length + bytes2.length;
        byte[] result = new byte[length];
        for (int i = 0; i < bytes1.length; ++i) {
            result[i] = bytes1[i];
        }
        for (int j = 0; j < bytes2.length; ++j) {
            result[bytes1.length + j] = bytes2[j];
        }
        return result;
    }

    public static byte[] replace(byte[] bytes, byte[] replacement, int index) {
        int i;
        byte[] result = new byte[bytes.length];
        for (i = 0; i < index; ++i) {
            result[i] = bytes[i];
        }
        for (i = 0; i < replacement.length; ++i) {
            result[index + i] = replacement[i];
        }
        return result;
    }

    public static boolean equalArrays(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }
}

