/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.enums.UuidVariant;
import com.github.f4b6a3.uuid.util.TimestampUtil;
import java.time.Instant;
import java.util.UUID;

public class UuidUtil {
    public static boolean isRfc4122Variant(UUID uuid) {
        int variant = uuid.variant();
        return variant == UuidVariant.VARIANT_RFC4122.getValue();
    }

    public static boolean isRandomBasedVersion(UUID uuid) {
        return uuid.version() == 4;
    }

    public static boolean isNameBasedVersion(UUID uuid) {
        int version = uuid.version();
        return version == 3 || version == 5;
    }

    public static boolean isTimeBasedVersion(UUID uuid) {
        int version = uuid.version();
        return version == 1;
    }

    public static boolean isSequentialVersion(UUID uuid) {
        int version = uuid.version();
        return version == 0;
    }

    public static boolean isDceSecurityVersion(UUID uuid) {
        int version = uuid.version();
        return version == 2;
    }

    public static long extractNodeIdentifier(UUID uuid) {
        if (!(UuidUtil.isTimeBasedVersion(uuid) || UuidUtil.isSequentialVersion(uuid) || UuidUtil.isDceSecurityVersion(uuid))) {
            throw new UnsupportedOperationException(String.format("Not a time-based, sequential or DCE Security UUID: %s.", uuid.toString()));
        }
        return uuid.getLeastSignificantBits() & 0xFFFFFFFFFFFFL;
    }

    public static long extractClockSequence(UUID uuid) {
        if (!UuidUtil.isTimeBasedVersion(uuid) && !UuidUtil.isSequentialVersion(uuid)) {
            throw new UnsupportedOperationException(String.format("Not a time-based or sequential UUID: %s.", uuid.toString()));
        }
        return uuid.getLeastSignificantBits() >>> 48 & 0x3FFFL;
    }

    public static Instant extractInstant(UUID uuid) {
        long timestamp = UuidUtil.extractTimestamp(uuid);
        return TimestampUtil.toInstant(timestamp);
    }

    public static long extractEpochMilliseconds(UUID uuid) {
        long timestamp = UuidUtil.extractTimestamp(uuid);
        return TimestampUtil.toInstant(timestamp).toEpochMilli();
    }

    public static long extractTimestamp(UUID uuid) {
        if (!UuidUtil.isTimeBasedVersion(uuid) && !UuidUtil.isSequentialVersion(uuid)) {
            throw new UnsupportedOperationException(String.format("Not a time-based or sequential UUID: %s.", uuid.toString()));
        }
        if (uuid.version() == 1) {
            return UuidUtil.extractTimeBasedTimestamp(uuid.getMostSignificantBits());
        }
        return UuidUtil.extractSequentialTimestamp(uuid.getMostSignificantBits());
    }

    private static long extractSequentialTimestamp(long msb) {
        long himid = (msb & 0xFFFFFFFFFFFF0000L) >>> 4;
        long low = msb & 0xFFFL;
        return himid | low;
    }

    private static long extractTimeBasedTimestamp(long msb) {
        long hii = (msb & 0xFFFFFFFF00000000L) >>> 32;
        long mid = (msb & 0xFFFF0000L) << 16;
        long low = (msb & 0xFFFL) << 48;
        return hii | mid | low;
    }

    public static byte extractDceSecurityLocalDomain(UUID uuid) {
        if (!UuidUtil.isDceSecurityVersion(uuid)) {
            throw new UnsupportedOperationException(String.format("Not a DCE Security UUID: %s.", uuid.toString()));
        }
        return (byte)((uuid.getLeastSignificantBits() & 0xFF000000000000L) >> 48);
    }

    public static int extractDceSecurityLocalIdentifier(UUID uuid) {
        if (!UuidUtil.isDceSecurityVersion(uuid)) {
            throw new UnsupportedOperationException(String.format("Not a DCE Security UUID: %s.", uuid.toString()));
        }
        return (int)(uuid.getMostSignificantBits() >> 32);
    }

    public static long extractDceSecurityTimestamp(UUID uuid) {
        if (!UuidUtil.isDceSecurityVersion(uuid)) {
            throw new UnsupportedOperationException(String.format("Not a DCE Security UUID: %s.", uuid.toString()));
        }
        return UuidUtil.extractTimeBasedTimestamp(uuid.getMostSignificantBits() & 0xFFFFFFFFL);
    }

    public static Instant extractDceSecurityInstant(UUID uuid) {
        long timestamp = UuidUtil.extractDceSecurityTimestamp(uuid);
        return TimestampUtil.toInstant(timestamp);
    }

    public static UUID fromSequentialToTimeBasedUuid(UUID uuid) {
        if (!UuidUtil.isSequentialVersion(uuid)) {
            throw new UnsupportedOperationException(String.format("Not a sequential UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = UuidUtil.formatTimeBasedMostSignificantBits(timestamp);
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    public static UUID fromTimeBasedToSequentialUuid(UUID uuid) {
        if (!UuidUtil.isTimeBasedVersion(uuid)) {
            throw new UnsupportedOperationException(String.format("Not a time-based UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = UuidUtil.formatSequentialMostSignificantBits(timestamp);
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    public static UUID fromTimeBasedToMssqlUuid(UUID uuid) {
        if (!UuidUtil.isTimeBasedVersion(uuid)) {
            throw new UnsupportedOperationException(String.format("Not a time-based UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = UuidUtil.formatMssqlMostSignificantBits(timestamp);
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    public static long formatSequentialMostSignificantBits(long timestamp) {
        long ts = 0L;
        ts |= (timestamp & 0xFFFFFFFFFFFF000L) << 4;
        return ts |= timestamp & 0xFFFL;
    }

    public static long formatTimeBasedMostSignificantBits(long timestamp) {
        long ts = 0L;
        ts |= (timestamp & 0xFFF000000000000L) >>> 48;
        ts |= (timestamp & 0xFFFF00000000L) >>> 16;
        ts |= (timestamp & 0xFFFFFFFFL) << 32;
        return ts |= 0x1000L;
    }

    public static long formatMssqlMostSignificantBits(long timestamp) {
        long ts1 = 0L;
        long ts2 = 0L;
        ts1 |= (timestamp & 0xFFF000000000000L) >>> 48;
        ts1 |= (timestamp & 0xFFFF00000000L) >>> 16;
        ts1 |= (timestamp & 0xFFFFFFFFL) << 32;
        ts2 |= ((ts1 |= 0x1000L) & 0xFF00000000000000L) >>> 24;
        ts2 |= (ts1 & 0xFF000000000000L) >>> 8;
        ts2 |= (ts1 & 0xFF0000000000L) << 8;
        ts2 |= (ts1 & 0xFF00000000L) << 24;
        ts2 |= (ts1 & 0xFF000000L) >>> 8;
        ts2 |= (ts1 & 0xFF0000L) << 8;
        ts2 |= (ts1 & 0xFF00L) >>> 8;
        return ts2 |= (ts1 & 0xFFL) << 8;
    }

    public static long formatRfc4122LeastSignificantBits(long nodeIdentifier, long clockSequence) {
        return clockSequence << 48 | nodeIdentifier & 0xFFFFFFFFFFFFL | Long.MIN_VALUE;
    }
}

