/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.nodeid;

import com.github.f4b6a3.uuid.nodeid.NodeIdentifierStrategy;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.NodeIdentifierUtil;
import com.github.f4b6a3.uuid.util.RandomUtil;
import com.github.f4b6a3.uuid.util.SettingsUtil;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;

public class DefaultNodeIdentifierStrategy
implements NodeIdentifierStrategy {
    protected long nodeIdentifier;
    protected static MessageDigest md;

    public DefaultNodeIdentifierStrategy() {
        long preferedNodeIdentifier = SettingsUtil.getNodeIdentifier();
        this.nodeIdentifier = preferedNodeIdentifier != 0L ? preferedNodeIdentifier : this.getSystemNodeIdentifier();
    }

    @Override
    public long getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    protected long getSystemNodeIdentifier() {
        md = this.getMessageDigest();
        byte[] bytes = null;
        byte[] hash = null;
        long number = 0L;
        String hn = DefaultNodeIdentifierStrategy.getHostName();
        String ni = DefaultNodeIdentifierStrategy.getNetworkInterfaces();
        String os = DefaultNodeIdentifierStrategy.getOperatingSystem();
        String vm = DefaultNodeIdentifierStrategy.getJavaVirtualMachine();
        String string = String.join((CharSequence)" ", hn, ni, os, vm);
        bytes = string.getBytes();
        hash = md.digest(bytes);
        number = ByteUtil.toNumber(hash) & 0xFFFFFFFFFFFFL;
        return NodeIdentifierUtil.setMulticastNodeIdentifier(number);
    }

    public static String getHostName() {
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            String canonical = InetAddress.getLocalHost().getCanonicalHostName();
            return String.join((CharSequence)" ", hostname, canonical);
        }
        catch (NullPointerException | UnknownHostException e) {
            return RandomUtil.nextLongHexadecimal();
        }
    }

    public static String getNetworkInterfaces() {
        try {
            TreeSet<String> sortedSet = new TreeSet<String>();
            StringBuffer buffer = new StringBuffer();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface nic = enumeration.nextElement();
                byte[] mac = nic.getHardwareAddress();
                List<InterfaceAddress> addrList = nic.getInterfaceAddresses();
                if (mac == null || addrList.isEmpty() || nic.isLoopback() || nic.isVirtual()) continue;
                String hwAddr = ByteUtil.toHexadecimal(mac);
                String name = nic.getName();
                String dispName = nic.getDisplayName();
                String ipAddr = null;
                for (InterfaceAddress addr : addrList) {
                    if (ipAddr == null) {
                        ipAddr = addr.getAddress().getHostAddress();
                        continue;
                    }
                    ipAddr = ipAddr + " " + addr.getAddress().getHostAddress();
                }
                sortedSet.add(String.join((CharSequence)" ", hwAddr, name, dispName, ipAddr));
            }
            for (Object item : sortedSet.toArray()) {
                buffer.append(" " + (String)item);
            }
            return buffer.toString().trim();
        }
        catch (NullPointerException | SocketException e) {
            return RandomUtil.nextLongHexadecimal();
        }
    }

    public static String getOperatingSystem() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String arch = System.getProperty("os.arch");
        return String.join((CharSequence)" ", name, version, arch);
    }

    public static String getJavaVirtualMachine() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        String home = System.getProperty("java.home");
        String sName = System.getProperty("java.specification.name");
        String sVersion = System.getProperty("java.specification.version");
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        String rtName = System.getProperty("java.runtime.name");
        String rtVersion = System.getProperty("java.runtime.version");
        return String.join((CharSequence)" ", vendor, version, home, sName, sVersion, vmName, vmVersion, rtName, rtVersion);
    }

    private MessageDigest getMessageDigest() {
        if (md == null) {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalError("Message digest algorithm not supported.", e);
            }
        }
        return md;
    }
}

