/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.abst;

import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.SettingsUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class UuidState {
    private static final String FILE_NAME = "uuidcreator";
    private static final String FILE_EXTENSION = "state";
    private static final String PROPERTY_TIMESTAMP = "timestamp";
    private static final String PROPERTY_CLOCKSEQ = "clockseq";
    private static final String PROPERTY_NODEID = "nodeid";
    private long timestamp = 0L;
    private int clockSequence = 0;
    private long nodeIdentifier = 0L;
    private boolean stored = false;
    private String directory = SettingsUtil.getStateDirectory();
    private String fileName;

    public UuidState() {
        this.updateFileName();
        this.load();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getClockSequence() {
        return this.clockSequence;
    }

    public void setClockSequence(int clockSequence) {
        this.clockSequence = clockSequence;
    }

    public long getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(long nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public boolean isStored() {
        return this.stored;
    }

    private void updateFileName() {
        this.fileName = String.join((CharSequence)"/", this.directory, FILE_NAME);
        this.fileName = String.join((CharSequence)".", this.fileName, FILE_EXTENSION);
    }

    public void store() {
        try {
            Properties properties = new Properties();
            properties.setProperty(PROPERTY_TIMESTAMP, ByteUtil.toHexadecimal(this.timestamp));
            properties.setProperty(PROPERTY_CLOCKSEQ, ByteUtil.toHexadecimal(this.clockSequence));
            properties.setProperty(PROPERTY_NODEID, ByteUtil.toHexadecimal(this.nodeIdentifier));
            properties.store(new FileWriter(this.fileName), null);
            this.stored = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.fileName));
            String timestamp = properties.getProperty(PROPERTY_TIMESTAMP, "0");
            String clockseq = properties.getProperty(PROPERTY_CLOCKSEQ, "0");
            String nodeid = properties.getProperty(PROPERTY_NODEID, "0");
            this.timestamp = ByteUtil.toNumber(timestamp);
            this.clockSequence = (int)ByteUtil.toNumber(clockseq) & 0x3FFF;
            this.nodeIdentifier = ByteUtil.toNumber(nodeid) & 0xFFFFFFFFFFFFL;
            this.stored = true;
        }
        catch (FileNotFoundException properties) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

