/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.abst;

import com.github.f4b6a3.uuid.factory.abst.AbstractUuidCreator;
import com.github.f4b6a3.uuid.util.ByteUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public abstract class AbstractNameBasedUuidCreator
extends AbstractUuidCreator {
    private UUID namespace;
    private MessageDigest md = null;
    protected static final String MESSAGE_DIGEST_MD5 = "MD5";
    protected static final String MESSAGE_DIGEST_SHA1 = "SHA-1";

    public AbstractNameBasedUuidCreator(int version, String messageDigest) {
        super(version);
        try {
            this.md = MessageDigest.getInstance(messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("Message digest algorithm not supported.", e);
        }
    }

    public <T extends AbstractNameBasedUuidCreator> T withNamespace(UUID namespace) {
        this.namespace = namespace;
        return (T)this;
    }

    public <T extends AbstractNameBasedUuidCreator> T withNamespace(String namespace) {
        UUID namespaceUUID;
        this.namespace = namespaceUUID = this.create(namespace);
        return (T)this;
    }

    public UUID create(String name) {
        return this.create(this.namespace, name);
    }

    public UUID create(String namespace, String name) {
        UUID namespaceUUID = this.create(namespace);
        return this.create(namespaceUUID, name);
    }

    public synchronized UUID create(UUID namespace, String name) {
        long msb = 0L;
        long lsb = 0L;
        byte[] namespaceBytes = null;
        byte[] nameBytes = null;
        byte[] bytes = null;
        byte[] hash = null;
        nameBytes = name.getBytes();
        if (namespace != null) {
            namespaceBytes = ByteUtil.toBytes(namespace.getMostSignificantBits());
            namespaceBytes = ByteUtil.concat(namespaceBytes, ByteUtil.toBytes(namespace.getLeastSignificantBits()));
        } else if (this.namespace != null) {
            namespaceBytes = ByteUtil.toBytes(this.namespace.getMostSignificantBits());
            namespaceBytes = ByteUtil.concat(namespaceBytes, ByteUtil.toBytes(this.namespace.getLeastSignificantBits()));
        } else {
            namespaceBytes = new byte[]{};
        }
        bytes = ByteUtil.concat(namespaceBytes, nameBytes);
        hash = this.md.digest(bytes);
        msb = ByteUtil.toNumber(ByteUtil.copy(hash, 0, 8));
        lsb = ByteUtil.toNumber(ByteUtil.copy(hash, 8, 16));
        lsb = this.setVariantBits(lsb);
        msb = this.setVersionBits(msb);
        return new UUID(msb, lsb);
    }
}

