/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.benchmark;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.NameBasedGenerator;
import com.fasterxml.uuid.impl.RandomBasedGenerator;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import com.github.f4b6a3.uuid.UuidCreator;
import com.github.f4b6a3.uuid.factory.CombGuidCreator;
import com.github.f4b6a3.uuid.factory.DceSecurityUuidCreator;
import com.github.f4b6a3.uuid.factory.MssqlGuidCreator;
import com.github.f4b6a3.uuid.factory.SequentialUuidCreator;
import com.github.f4b6a3.uuid.factory.TimeBasedUuidCreator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.Main;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@Warmup(iterations=1, batchSize=1000)
@Measurement(iterations=10, batchSize=100000)
@BenchmarkMode(value={Mode.SingleShotTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class BenchmarkRunner {
    private String name;
    private byte[] bytes;
    private NameBasedGenerator jugNameBasedGenerator;
    private TimeBasedGenerator jugTimeBasedGenerator;
    private TimeBasedGenerator jugTimeBasedMACGenerator;
    private RandomBasedGenerator jugRandomGenerator;
    private SequentialUuidCreator sequentialCreator;
    private TimeBasedUuidCreator timeBasedCreator;
    private SequentialUuidCreator sequentialMacCreator;
    private TimeBasedUuidCreator timeBasedMacCreator;
    private DceSecurityUuidCreator dceSecurityCreator;
    private DceSecurityUuidCreator dceSecurityWithMacCreator;
    private MssqlGuidCreator mssqlCreator;
    private CombGuidCreator combCreator;

    @Setup
    public void setUp() {
        this.name = "https://github.com/";
        this.bytes = this.name.getBytes();
        this.jugNameBasedGenerator = Generators.nameBasedGenerator();
        this.jugTimeBasedGenerator = Generators.timeBasedGenerator();
        this.jugTimeBasedMACGenerator = Generators.timeBasedGenerator((EthernetAddress)EthernetAddress.fromInterface());
        this.jugRandomGenerator = Generators.randomBasedGenerator();
        this.sequentialCreator = UuidCreator.getSequentialCreator();
        this.timeBasedCreator = UuidCreator.getTimeBasedCreator();
        this.sequentialMacCreator = (SequentialUuidCreator)UuidCreator.getSequentialCreator().withHardwareAddress();
        this.timeBasedMacCreator = (TimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withHardwareAddress();
        this.dceSecurityCreator = UuidCreator.getDceSecurityCreator();
        this.dceSecurityWithMacCreator = (DceSecurityUuidCreator)UuidCreator.getDceSecurityCreator().withHardwareAddress();
        this.mssqlCreator = UuidCreator.getMssqlCreator();
        this.combCreator = UuidCreator.getCombCreator();
    }

    @Benchmark
    public UUID Java_Random() {
        return UUID.randomUUID();
    }

    @Benchmark
    public UUID Java_NameBased() {
        return UUID.nameUUIDFromBytes(this.bytes);
    }

    @Benchmark
    public com.eaio.uuid.UUID EAIO_TimeBasedWithMac() {
        return new com.eaio.uuid.UUID();
    }

    @Benchmark
    public UUID JUG_NameBased() {
        return this.jugNameBasedGenerator.generate(this.bytes);
    }

    @Benchmark
    public UUID JUG_TimeBased() {
        return this.jugTimeBasedGenerator.generate();
    }

    @Benchmark
    public UUID JUG_TimeBasedWithMAC() {
        return this.jugTimeBasedMACGenerator.generate();
    }

    @Benchmark
    public UUID JUG_Random() {
        return this.jugRandomGenerator.generate();
    }

    @Benchmark
    public UUID UuidCreator_Random() {
        return UuidCreator.getRandom();
    }

    @Benchmark
    public UUID UuidCreator_FastRandom() {
        return UuidCreator.getFastRandom();
    }

    @Benchmark
    public UUID UuidCreator_DceSecurity() {
        return this.dceSecurityCreator.create((byte)1, 1701);
    }

    @Benchmark
    public UUID UuidCreator_DceSecurityWithMac() {
        return this.dceSecurityWithMacCreator.create((byte)1, 1701);
    }

    @Benchmark
    public UUID UuidCreator_NameBasedMd5() {
        return UuidCreator.getNameBasedMd5(this.name);
    }

    @Benchmark
    public UUID UuidCreator_NameBasedSha1() {
        return UuidCreator.getNameBasedSha1(this.name);
    }

    @Benchmark
    public UUID UuidCreator_Sequential() {
        return this.sequentialCreator.create();
    }

    @Benchmark
    public UUID UuidCreator_SequentialWithMac() {
        return this.sequentialMacCreator.create();
    }

    @Benchmark
    public UUID UuidCreator_TimeBased() {
        return this.timeBasedCreator.create();
    }

    @Benchmark
    public UUID UuidCreator_TimeBasedWithMac() {
        return this.timeBasedMacCreator.create();
    }

    @Benchmark
    public UUID UuidCreator_MssqlGuid() {
        return this.mssqlCreator.create();
    }

    @Benchmark
    public UUID UuidCreator_CombGuid() {
        return this.combCreator.create();
    }

    public static void main(String[] args) throws Exception {
        Main.main((String[])args);
    }
}

