/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.util.UlidValidator;
import com.github.f4b6a3.ulid.util.internal.UlidStruct;
import java.time.Instant;
import java.util.UUID;

public final class UlidUtil {
    protected static final int BASE_32 = 32;
    protected static final int ULID_LENGTH = 26;
    protected static final char[] ALPHABET_CROCKFORD = "0123456789ABCDEFGHJKMNPQRSTVWXYZOIL".toCharArray();
    protected static final char[] ALPHABET_JAVA = "0123456789abcdefghijklmnopqrstuv011".toCharArray();

    private UlidUtil() {
    }

    public static long extractUnixMilliseconds(UUID ulid) {
        return UlidUtil.extractTimestamp(ulid);
    }

    public static long extractUnixMilliseconds(String ulid) {
        UlidValidator.validate(ulid);
        return UlidUtil.extractTimestamp(ulid);
    }

    public static Instant extractInstant(UUID ulid) {
        long milliseconds = UlidUtil.extractTimestamp(ulid);
        return Instant.ofEpochMilli(milliseconds);
    }

    public static Instant extractInstant(String ulid) {
        UlidValidator.validate(ulid);
        long milliseconds = UlidUtil.extractTimestamp(ulid);
        return Instant.ofEpochMilli(milliseconds);
    }

    protected static long extractTimestamp(UUID ulid) {
        return ulid.getMostSignificantBits() >>> 16;
    }

    protected static long extractTimestamp(String ulid) {
        return UlidStruct.of((String)ulid).time;
    }

    public static String extractTimestampComponent(String ulid) {
        UlidValidator.validate(ulid);
        return ulid.substring(0, 10);
    }

    public static String extractRandomnessComponent(String ulid) {
        UlidValidator.validate(ulid);
        return ulid.substring(10, 26);
    }
}

