/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.exception.InvalidUlidException;
import com.github.f4b6a3.ulid.util.internal.UlidStruct;

public final class UlidValidator {
    protected static final long TIMESTAMP_MAX = (long)Math.pow(2.0, 48.0) - 1L;
    protected static final int ULID_LENGTH = 26;

    private UlidValidator() {
    }

    public static boolean isValid(String ulid) {
        if (ulid == null) {
            return false;
        }
        char[] chars = ulid.toCharArray();
        return UlidValidator.isValidString(chars) && UlidValidator.isValidTimestamp(chars);
    }

    public static void validate(String ulid) {
        if (!UlidValidator.isValid(ulid)) {
            throw new InvalidUlidException(String.format("Invalid ULID: %s.", ulid));
        }
    }

    protected static boolean isValidString(char[] c) {
        int hyphen = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '-') {
                ++hyphen;
                continue;
            }
            if (c[i] == 'U' || c[i] == 'u') {
                return false;
            }
            if (c[i] >= 'A' && c[i] <= 'Z' || c[i] >= '0' && c[i] <= '9' || c[i] >= 'a' && c[i] <= 'z') continue;
            return false;
        }
        return c.length - hyphen == 26;
    }

    protected static boolean isValidTimestamp(char[] chars) {
        long time = 0L;
        time |= UlidStruct.BASE32_VALUES[chars[0]] << 45;
        time |= UlidStruct.BASE32_VALUES[chars[1]] << 40;
        time |= UlidStruct.BASE32_VALUES[chars[2]] << 35;
        time |= UlidStruct.BASE32_VALUES[chars[3]] << 30;
        time |= UlidStruct.BASE32_VALUES[chars[4]] << 25;
        time |= UlidStruct.BASE32_VALUES[chars[5]] << 20;
        time |= UlidStruct.BASE32_VALUES[chars[6]] << 15;
        time |= UlidStruct.BASE32_VALUES[chars[7]] << 10;
        time |= UlidStruct.BASE32_VALUES[chars[8]] << 5;
        return (time |= UlidStruct.BASE32_VALUES[chars[9]]) >= 0L && time <= TIMESTAMP_MAX;
    }
}

