/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.creator;

import com.github.f4b6a3.ulid.exception.UlidCreatorException;
import com.github.f4b6a3.ulid.strategy.TimestampStrategy;
import com.github.f4b6a3.ulid.strategy.timestamp.DefaultTimestampStrategy;
import com.github.f4b6a3.ulid.util.UlidConverter;
import com.github.f4b6a3.util.FingerprintUtil;
import com.github.f4b6a3.util.RandomUtil;
import com.github.f4b6a3.util.random.Xorshift128PlusRandom;
import java.util.Random;
import java.util.UUID;

public class UlidBasedGuidCreator {
    protected long randomMsb = 0L;
    protected long randomLsb = 0L;
    protected long randomLsbMax;
    protected long randomMsbMax;
    protected static final long HALF_RANDOM_COMPONENT = 0xFFFFFFFFFFL;
    protected static final long INCREMENT_MAX = 0x10000000000L;
    protected long previousTimestamp;
    protected Random random;
    protected static final String OVERRUN_MESSAGE = "The system overran the generator by requesting too many GUIDs.";
    protected TimestampStrategy timestampStrategy;

    public UlidBasedGuidCreator() {
        this.reset();
        this.timestampStrategy = new DefaultTimestampStrategy();
    }

    public synchronized UUID create() {
        long timestamp = this.getTimestamp();
        long randomHi = this.truncate(this.randomMsb);
        long randomLo = this.truncate(this.randomLsb);
        long msb = timestamp << 16 | randomHi >>> 24;
        long lsb = randomHi << 40 | randomLo;
        return new UUID(msb, lsb);
    }

    public synchronized String createString() {
        return UlidConverter.toString(this.create());
    }

    protected synchronized long getTimestamp() {
        long timestamp = this.timestampStrategy.getTimestamp();
        if (timestamp == this.previousTimestamp) {
            this.increment();
        } else {
            this.reset();
        }
        this.previousTimestamp = timestamp;
        return timestamp;
    }

    protected synchronized void reset() {
        if (this.random == null) {
            this.randomMsb = this.truncate(RandomUtil.get().nextLong());
            this.randomLsb = this.truncate(RandomUtil.get().nextLong());
        } else {
            this.randomMsb = this.truncate(this.random.nextLong());
            this.randomLsb = this.truncate(this.random.nextLong());
        }
        this.randomMsbMax = this.randomMsb | 0x10000000000L;
        this.randomLsbMax = this.randomLsb | 0x10000000000L;
    }

    protected synchronized void increment() {
        if (++this.randomLsb == this.randomLsbMax && ++this.randomMsb == this.randomMsbMax) {
            this.reset();
            throw new UlidCreatorException(OVERRUN_MESSAGE);
        }
    }

    public synchronized <T extends UlidBasedGuidCreator> T withTimestampStrategy(TimestampStrategy timestampStrategy) {
        this.timestampStrategy = timestampStrategy;
        return (T)this;
    }

    public synchronized <T extends UlidBasedGuidCreator> T withRandomGenerator(Random random) {
        this.random = random;
        return (T)this;
    }

    public synchronized <T extends UlidBasedGuidCreator> T withFastRandomGenerator() {
        int salt = (int)FingerprintUtil.getFingerprint();
        this.random = new Xorshift128PlusRandom(salt);
        return (T)this;
    }

    protected synchronized long truncate(long value) {
        return value & 0xFFFFFFFFFFL;
    }

    protected long extractRandomLsb(UUID uuid) {
        return uuid.getLeastSignificantBits() & 0xFFFFFFFFFFL;
    }

    protected long extractRandomMsb(UUID uuid) {
        return (uuid.getMostSignificantBits() & 0xFFFFL) << 24 | uuid.getLeastSignificantBits() >>> 40;
    }
}

