/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.util.Base32Util;
import com.github.f4b6a3.ulid.util.ByteUtil;
import java.time.Instant;
import java.util.UUID;

public class UlidUtil {
    protected static final long TIMESTAMP_MAX = (long)Math.pow(2.0, 48.0) - 1L;
    protected static final String ULID_PATTERN_STRICT = "^[0-9a-hjkmnp-tv-zA-HJKMNP-TV-Z]{26}$";
    protected static final String ULID_PATTERN_LOOSE = "^[0-9a-tv-zA-TV-Z]{26}$";

    private UlidUtil() {
    }

    public static String fromUuidToUlid(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        long timeNumber = msb >>> 16;
        String timestampComponent = UlidUtil.leftPad(Base32Util.toBase32Crockford(timeNumber));
        byte[] randBytes = new byte[10];
        randBytes[0] = (byte)(msb >>> 8);
        randBytes[1] = (byte)msb;
        byte[] lsbBytes = ByteUtil.toBytes(lsb);
        System.arraycopy(lsbBytes, 0, randBytes, 2, 8);
        String randomnessComponent = Base32Util.toBase32Crockford(randBytes);
        return timestampComponent + randomnessComponent;
    }

    public static UUID fromUlidToUuid(String ulid) {
        UlidUtil.validate(ulid);
        String timestampComponent = ulid.substring(0, 10);
        long timeNumber = Base32Util.fromBase32CrockfordAsLong(timestampComponent);
        String randomnessComponent = ulid.substring(10, 26);
        byte[] randBytes = Base32Util.fromBase32Crockford(randomnessComponent);
        byte[] lsbBytes = new byte[8];
        System.arraycopy(randBytes, 2, lsbBytes, 0, 8);
        long msb = timeNumber << 16 | (long)(randBytes[0] << 8) & 0xFF00L | (long)randBytes[1] & 0xFFL;
        long lsb = ByteUtil.toNumber(lsbBytes);
        return new UUID(msb, lsb);
    }

    public static byte[] fromUuidToBytes(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] msbBytes = ByteUtil.toBytes(msb);
        byte[] lsbBytes = ByteUtil.toBytes(lsb);
        return ByteUtil.concat(msbBytes, lsbBytes);
    }

    public static UUID fromBytesToUuid(byte[] bytes) {
        byte[] msbBytes = new byte[8];
        System.arraycopy(bytes, 0, msbBytes, 0, 8);
        byte[] lsbBytes = new byte[8];
        System.arraycopy(bytes, 8, lsbBytes, 0, 8);
        long msb = ByteUtil.toNumber(msbBytes);
        long lsb = ByteUtil.toNumber(lsbBytes);
        return new UUID(msb, lsb);
    }

    public static String fromBytesToUlid(byte[] bytes) {
        byte[] timeBytes = new byte[6];
        System.arraycopy(bytes, 0, timeBytes, 0, 6);
        long timeNumber = ByteUtil.toNumber(timeBytes);
        String timestampComponent = UlidUtil.leftPad(Base32Util.toBase32Crockford(timeNumber));
        byte[] randBytes = new byte[10];
        System.arraycopy(bytes, 6, randBytes, 0, 10);
        String randomnessComponent = Base32Util.toBase32Crockford(randBytes);
        return timestampComponent + randomnessComponent;
    }

    public static byte[] fromUlidToBytes(String ulid) {
        UlidUtil.validate(ulid);
        byte[] bytes = new byte[16];
        String timestampComponent = ulid.substring(0, 10);
        long timeNumber = Base32Util.fromBase32CrockfordAsLong(timestampComponent);
        byte[] timeBytes = ByteUtil.toBytes(timeNumber);
        System.arraycopy(timeBytes, 2, bytes, 0, 6);
        String randomnessComponent = ulid.substring(10, 26);
        byte[] randBytes = Base32Util.fromBase32Crockford(randomnessComponent);
        System.arraycopy(randBytes, 0, bytes, 6, 10);
        return bytes;
    }

    protected static void validate(String ulid) {
        UlidUtil.validate(ulid, false);
    }

    protected static void validate(String ulid, boolean strict) {
        if (!UlidUtil.isValid(ulid, strict)) {
            throw new UlidUtilException(String.format("Invalid ULID: %s.", ulid));
        }
    }

    public static boolean isValid(String ulid) {
        return UlidUtil.isValid(ulid, false);
    }

    public static boolean isValid(String ulid, boolean strict) {
        if (ulid == null || ulid.isEmpty()) {
            return false;
        }
        boolean matches = false;
        if (strict) {
            matches = ulid.matches(ULID_PATTERN_STRICT);
        } else {
            String u = ulid.replaceAll("-", "");
            matches = u.matches(ULID_PATTERN_LOOSE);
        }
        if (!matches) {
            return false;
        }
        long timestamp = UlidUtil.extractUnixMilliseconds(ulid);
        return timestamp >= 0L && timestamp <= TIMESTAMP_MAX;
    }

    public static long extractTimestamp(String ulid) {
        UlidUtil.validate(ulid);
        return UlidUtil.extractUnixMilliseconds(ulid);
    }

    public static Instant extractInstant(String ulid) {
        long milliseconds = UlidUtil.extractTimestamp(ulid);
        return Instant.ofEpochMilli(milliseconds);
    }

    public static String extractTimestampComponent(String ulid) {
        UlidUtil.validate(ulid);
        return ulid.substring(0, 10);
    }

    public static String extractRandomnessComponent(String ulid) {
        UlidUtil.validate(ulid);
        return ulid.substring(10, 26);
    }

    protected static long extractUnixMilliseconds(String ulid) {
        String milliseconds = ulid.substring(0, 10);
        return Base32Util.fromBase32CrockfordAsLong(milliseconds);
    }

    private static String leftPad(String unpadded) {
        return "0000000000".substring(unpadded.length()) + unpadded;
    }

    public static class UlidUtilException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UlidUtilException(String message) {
            super(message);
        }
    }
}

