/*
 * Decompiled with CFR 0.152.
 */
package com.github.exabrial.jca.udp.ra;

import com.github.exabrial.jca.udp.ra.UDPWorker;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class UDPResourceAdapter
implements ResourceAdapter {
    private String address;
    private Integer port;
    private Integer maxPacketSize;
    private WorkManager workManager;
    private UDPWorker udpWorker;

    public void start(BootstrapContext bootstrapContext) {
        this.workManager = bootstrapContext.getWorkManager();
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws ResourceException {
        try {
            this.udpWorker = new UDPWorker(this.workManager, messageEndpointFactory, this.maxPacketSize, this.port, this.address);
            this.workManager.scheduleWork((Work)this.udpWorker);
        }
        catch (SocketException | UnknownHostException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory mepf, ActivationSpec as) {
        this.udpWorker.release();
    }

    public void stop() {
        this.udpWorker.release();
    }

    public XAResource[] getXAResources(ActivationSpec[] as) throws ResourceException {
        throw new ResourceException("no XA support");
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setMaxPacketSize(Integer maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UDPResourceAdapter)) {
            return false;
        }
        UDPResourceAdapter other = (UDPResourceAdapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$maxPacketSize = this.getMaxPacketSize();
        Integer other$maxPacketSize = other.getMaxPacketSize();
        if (this$maxPacketSize == null ? other$maxPacketSize != null : !((Object)this$maxPacketSize).equals(other$maxPacketSize)) {
            return false;
        }
        WorkManager this$workManager = this.workManager;
        WorkManager other$workManager = other.workManager;
        if (this$workManager == null ? other$workManager != null : !this$workManager.equals(other$workManager)) {
            return false;
        }
        UDPWorker this$udpWorker = this.udpWorker;
        UDPWorker other$udpWorker = other.udpWorker;
        return !(this$udpWorker == null ? other$udpWorker != null : !((Object)this$udpWorker).equals(other$udpWorker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UDPResourceAdapter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $maxPacketSize = this.getMaxPacketSize();
        result = result * 59 + ($maxPacketSize == null ? 43 : ((Object)$maxPacketSize).hashCode());
        WorkManager $workManager = this.workManager;
        result = result * 59 + ($workManager == null ? 43 : $workManager.hashCode());
        UDPWorker $udpWorker = this.udpWorker;
        result = result * 59 + ($udpWorker == null ? 43 : ((Object)$udpWorker).hashCode());
        return result;
    }

    public String toString() {
        return "UDPResourceAdapter(address=" + this.getAddress() + ", port=" + this.getPort() + ", maxPacketSize=" + this.getMaxPacketSize() + ", workManager=" + this.workManager + ", udpWorker=" + this.udpWorker + ")";
    }
}

