/*
 * Decompiled with CFR 0.152.
 */
package com.github.exabrial.jca.udp.ra;

import com.github.exabrial.jca.udp.ra.UDPClientWorker;
import com.github.exabrial.jca.udp.ra.UDPUtil;
import java.net.DatagramSocket;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPWorker
implements Work {
    private static final Logger log = LoggerFactory.getLogger(UDPWorker.class);
    private final WorkManager workManager;
    private final MessageEndpointFactory messageEndpointFactory;
    private final DatagramSocket datagramSocket;
    private final Integer maxPacketSize;
    private volatile boolean done;

    public UDPWorker(WorkManager workManager, MessageEndpointFactory messageEndpointFactory, DatagramSocket datagramSocket, Integer maxPacketSize) {
        this.workManager = workManager;
        this.messageEndpointFactory = messageEndpointFactory;
        this.datagramSocket = datagramSocket;
        this.maxPacketSize = maxPacketSize;
    }

    public void run() {
        log.info("run() UDP listener starting datagramSocket.port:{}", (Object)this.datagramSocket.getPort());
        this.done = false;
        while (!this.done) {
            try {
                UDPUtil.InboundPacket inboundPacket = UDPUtil.receive(this.datagramSocket, this.maxPacketSize);
                if (inboundPacket == null) continue;
                this.workManager.scheduleWork((Work)new UDPClientWorker(this.messageEndpointFactory, this.datagramSocket, inboundPacket));
            }
            catch (Exception e) {
                log.error("run() error occured during lifecycle", (Throwable)e);
            }
        }
        log.info("run() UDP listener stopped");
    }

    public void release() {
        log.info("release() signaling for UDP Listener stop");
        this.done = true;
        this.datagramSocket.close();
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        return this.messageEndpointFactory;
    }

    public DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    public Integer getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UDPWorker)) {
            return false;
        }
        UDPWorker other = (UDPWorker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WorkManager this$workManager = this.getWorkManager();
        WorkManager other$workManager = other.getWorkManager();
        if (this$workManager == null ? other$workManager != null : !this$workManager.equals(other$workManager)) {
            return false;
        }
        MessageEndpointFactory this$messageEndpointFactory = this.getMessageEndpointFactory();
        MessageEndpointFactory other$messageEndpointFactory = other.getMessageEndpointFactory();
        if (this$messageEndpointFactory == null ? other$messageEndpointFactory != null : !this$messageEndpointFactory.equals(other$messageEndpointFactory)) {
            return false;
        }
        DatagramSocket this$datagramSocket = this.getDatagramSocket();
        DatagramSocket other$datagramSocket = other.getDatagramSocket();
        if (this$datagramSocket == null ? other$datagramSocket != null : !this$datagramSocket.equals(other$datagramSocket)) {
            return false;
        }
        Integer this$maxPacketSize = this.getMaxPacketSize();
        Integer other$maxPacketSize = other.getMaxPacketSize();
        if (this$maxPacketSize == null ? other$maxPacketSize != null : !((Object)this$maxPacketSize).equals(other$maxPacketSize)) {
            return false;
        }
        return this.isDone() == other.isDone();
    }

    protected boolean canEqual(Object other) {
        return other instanceof UDPWorker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WorkManager $workManager = this.getWorkManager();
        result = result * 59 + ($workManager == null ? 43 : $workManager.hashCode());
        MessageEndpointFactory $messageEndpointFactory = this.getMessageEndpointFactory();
        result = result * 59 + ($messageEndpointFactory == null ? 43 : $messageEndpointFactory.hashCode());
        DatagramSocket $datagramSocket = this.getDatagramSocket();
        result = result * 59 + ($datagramSocket == null ? 43 : $datagramSocket.hashCode());
        Integer $maxPacketSize = this.getMaxPacketSize();
        result = result * 59 + ($maxPacketSize == null ? 43 : ((Object)$maxPacketSize).hashCode());
        result = result * 59 + (this.isDone() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "UDPWorker(workManager=" + this.getWorkManager() + ", messageEndpointFactory=" + this.getMessageEndpointFactory() + ", datagramSocket=" + this.getDatagramSocket() + ", maxPacketSize=" + this.getMaxPacketSize() + ", done=" + this.isDone() + ")";
    }
}

