/*
 * Decompiled with CFR 0.152.
 */
package com.github.exabrial.jca.udp.ra;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;

public final class UDPUtil {
    public static InboundPacket receive(DatagramSocket datagramSocket, int maxPacketSize) throws IOException {
        InboundPacket inboundPacket;
        byte[] buffer = new byte[maxPacketSize];
        DatagramPacket datagramPacket = new DatagramPacket(buffer, buffer.length);
        try {
            datagramSocket.receive(datagramPacket);
            inboundPacket = new InboundPacket(datagramPacket.getData(), datagramPacket.getAddress(), datagramPacket.getPort());
        }
        catch (SocketTimeoutException e) {
            inboundPacket = null;
        }
        return inboundPacket;
    }

    public static void send(DatagramSocket datagramSocket, InboundPacket inboundPacket) throws IOException {
        byte[] payload = inboundPacket.getData();
        DatagramPacket datagramPacket = new DatagramPacket(payload, payload.length);
        datagramPacket.setAddress(inboundPacket.getSourceAddress());
        datagramPacket.setPort(inboundPacket.getSourcePort());
        datagramSocket.send(datagramPacket);
    }

    public static class InboundPacket {
        private final byte[] data;
        private final InetAddress sourceAddress;
        private final int sourcePort;

        public byte[] getData() {
            return this.data;
        }

        public InetAddress getSourceAddress() {
            return this.sourceAddress;
        }

        public int getSourcePort() {
            return this.sourcePort;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InboundPacket)) {
                return false;
            }
            InboundPacket other = (InboundPacket)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getData(), other.getData())) {
                return false;
            }
            InetAddress this$sourceAddress = this.getSourceAddress();
            InetAddress other$sourceAddress = other.getSourceAddress();
            if (this$sourceAddress == null ? other$sourceAddress != null : !((Object)this$sourceAddress).equals(other$sourceAddress)) {
                return false;
            }
            return this.getSourcePort() == other.getSourcePort();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InboundPacket;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getData());
            InetAddress $sourceAddress = this.getSourceAddress();
            result = result * 59 + ($sourceAddress == null ? 43 : ((Object)$sourceAddress).hashCode());
            result = result * 59 + this.getSourcePort();
            return result;
        }

        public String toString() {
            return "UDPUtil.InboundPacket(data=" + Arrays.toString(this.getData()) + ", sourceAddress=" + this.getSourceAddress() + ", sourcePort=" + this.getSourcePort() + ")";
        }

        public InboundPacket(byte[] data, InetAddress sourceAddress, int sourcePort) {
            this.data = data;
            this.sourceAddress = sourceAddress;
            this.sourcePort = sourcePort;
        }
    }
}

