/*
 * Decompiled with CFR 0.152.
 */
package com.github.exabrial.jca.udp.ra;

import com.github.exabrial.jca.udp.ra.UDPWorker;
import java.net.DatagramSocket;
import java.net.SocketException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class UDPResourceAdapter
implements ResourceAdapter {
    private Integer port;
    private Integer maxPacketSize;
    private WorkManager workManager;
    private Work work;

    public void start(BootstrapContext bootstrapContext) {
        this.workManager = bootstrapContext.getWorkManager();
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws ResourceException {
        try {
            DatagramSocket datagramSocket = new DatagramSocket(this.port);
            datagramSocket.setSoTimeout(1000);
            this.work = new UDPWorker(this.workManager, messageEndpointFactory, datagramSocket, this.maxPacketSize);
            this.workManager.scheduleWork(this.work);
        }
        catch (SocketException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory mepf, ActivationSpec as) {
        this.work.release();
    }

    public void stop() {
        this.work.release();
    }

    public XAResource[] getXAResources(ActivationSpec[] as) throws ResourceException {
        throw new ResourceException("no XA support");
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setMaxPacketSize(Integer maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UDPResourceAdapter)) {
            return false;
        }
        UDPResourceAdapter other = (UDPResourceAdapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$maxPacketSize = this.getMaxPacketSize();
        Integer other$maxPacketSize = other.getMaxPacketSize();
        if (this$maxPacketSize == null ? other$maxPacketSize != null : !((Object)this$maxPacketSize).equals(other$maxPacketSize)) {
            return false;
        }
        WorkManager this$workManager = this.workManager;
        WorkManager other$workManager = other.workManager;
        if (this$workManager == null ? other$workManager != null : !this$workManager.equals(other$workManager)) {
            return false;
        }
        Work this$work = this.work;
        Work other$work = other.work;
        return !(this$work == null ? other$work != null : !this$work.equals(other$work));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UDPResourceAdapter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $maxPacketSize = this.getMaxPacketSize();
        result = result * 59 + ($maxPacketSize == null ? 43 : ((Object)$maxPacketSize).hashCode());
        WorkManager $workManager = this.workManager;
        result = result * 59 + ($workManager == null ? 43 : $workManager.hashCode());
        Work $work = this.work;
        result = result * 59 + ($work == null ? 43 : $work.hashCode());
        return result;
    }

    public String toString() {
        return "UDPResourceAdapter(port=" + this.getPort() + ", maxPacketSize=" + this.getMaxPacketSize() + ", workManager=" + this.workManager + ", work=" + this.work + ")";
    }
}

