/*
 * Decompiled with CFR 0.152.
 */
package com.github.exabrial.jca.udp.ra;

import com.github.exabrial.jca.udp.UDPMessageListener;
import com.github.exabrial.jca.udp.ra.UDPUtil;
import java.net.DatagramSocket;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPClientWorker
implements Work {
    private static final Logger log = LoggerFactory.getLogger(UDPClientWorker.class);
    private final MessageEndpointFactory messageEndpointFactory;
    private final DatagramSocket datagramSocket;
    private final UDPUtil.InboundPacket inboundPacket;

    public UDPClientWorker(MessageEndpointFactory messageEndpointFactory, DatagramSocket datagramSocket, UDPUtil.InboundPacket inboundPacket) {
        this.messageEndpointFactory = messageEndpointFactory;
        this.datagramSocket = datagramSocket;
        this.inboundPacket = inboundPacket;
    }

    public void run() {
        try {
            log.trace("run() starting handler");
            UDPMessageListener messageListener = (UDPMessageListener)this.messageEndpointFactory.createEndpoint(null);
            byte[] reply = messageListener.onPacket(this.inboundPacket.getData(), this.inboundPacket.getSourceAddress());
            if (reply != null) {
                UDPUtil.send(this.datagramSocket, new UDPUtil.InboundPacket(reply, this.inboundPacket.getSourceAddress(), this.inboundPacket.getSourcePort()));
            }
            log.trace("run() client handler complete");
        }
        catch (Exception e) {
            log.error("run() error occured while handling packet", (Throwable)e);
            log.error("run() inboundPacket:{}", (Object)this.inboundPacket);
        }
    }

    public void release() {
    }
}

