/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.itemclick;

import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRowRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.listener.itemclick.AbstractItemClickListener;

public class CellRecyclerViewItemClickListener
extends AbstractItemClickListener {
    @NonNull
    private CellRecyclerView mCellRecyclerView;

    public CellRecyclerViewItemClickListener(@NonNull CellRecyclerView recyclerView, @NonNull ITableView tableView) {
        super(recyclerView, tableView);
        this.mCellRecyclerView = tableView.getCellRecyclerView();
    }

    @Override
    protected boolean clickAction(@NonNull RecyclerView view, @NonNull MotionEvent e) {
        View childView = view.findChildViewUnder(e.getX(), e.getY());
        if (childView != null) {
            AbstractViewHolder holder = (AbstractViewHolder)this.mRecyclerView.getChildViewHolder(childView);
            CellRowRecyclerViewAdapter adapter = (CellRowRecyclerViewAdapter)this.mRecyclerView.getAdapter();
            int column = holder.getAdapterPosition();
            int row = adapter.getYPosition();
            if (!this.mTableView.isIgnoreSelectionColors()) {
                this.mSelectionHandler.setSelectedCellPositions(holder, column, row);
            }
            this.getTableViewListener().onCellClicked(holder, column, row);
            return true;
        }
        return false;
    }

    @Override
    protected void longPressAction(@NonNull MotionEvent e) {
        if (this.mRecyclerView.getScrollState() != 0 || this.mCellRecyclerView.getScrollState() != 0) {
            return;
        }
        View child = this.mRecyclerView.findChildViewUnder(e.getX(), e.getY());
        if (child != null) {
            RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(child);
            CellRowRecyclerViewAdapter adapter = (CellRowRecyclerViewAdapter)this.mRecyclerView.getAdapter();
            this.getTableViewListener().onCellLongPressed(holder, holder.getAdapterPosition(), adapter.getYPosition());
        }
    }
}

