/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractSorterViewHolder;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.sort.ColumnSortHelper;
import com.evrencoskun.tableview.sort.SortState;
import java.util.List;

public class ColumnHeaderRecyclerViewAdapter<CH>
extends AbstractRecyclerViewAdapter<CH> {
    @NonNull
    private ITableAdapter mTableAdapter;
    private ITableView mTableView;
    private ColumnSortHelper mColumnSortHelper;

    public ColumnHeaderRecyclerViewAdapter(@NonNull Context context, @Nullable List<CH> itemList, @NonNull ITableAdapter tableAdapter) {
        super(context, itemList);
        this.mTableAdapter = tableAdapter;
        this.mTableView = tableAdapter.getTableView();
    }

    @NonNull
    public AbstractViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.mTableAdapter.onCreateColumnHeaderViewHolder(parent, viewType);
    }

    public void onBindViewHolder(@NonNull AbstractViewHolder holder, int position) {
        this.mTableAdapter.onBindColumnHeaderViewHolder(holder, this.getItem(position), position);
    }

    @Override
    public int getItemViewType(int position) {
        return this.mTableAdapter.getColumnHeaderItemViewType(position);
    }

    public void onViewAttachedToWindow(@NonNull AbstractViewHolder viewHolder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)viewHolder);
        AbstractViewHolder.SelectionState selectionState = this.mTableView.getSelectionHandler().getColumnSelectionState(viewHolder.getAdapterPosition());
        if (!this.mTableView.isIgnoreSelectionColors()) {
            this.mTableView.getSelectionHandler().changeColumnBackgroundColorBySelectionStatus(viewHolder, selectionState);
        }
        viewHolder.setSelected(selectionState);
        if (this.mTableView.isSortable() && viewHolder instanceof AbstractSorterViewHolder) {
            SortState state = this.getColumnSortHelper().getSortingStatus(viewHolder.getAdapterPosition());
            ((AbstractSorterViewHolder)viewHolder).onSortingStatusChanged(state);
        }
    }

    @NonNull
    public ColumnSortHelper getColumnSortHelper() {
        if (this.mColumnSortHelper == null) {
            this.mColumnSortHelper = new ColumnSortHelper(this.mTableView.getColumnHeaderLayoutManager());
        }
        return this.mColumnSortHelper;
    }
}

